/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DelaunayFast;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.Scalar;
import visad.ScaledUnit;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.FakeCoordinateSystem;

class FakeData {
    private Unit foot = new ScaledUnit(0.3048, SI.meter, "foot");
    private Unit pound = new ScaledUnit(2.204622, SI.kilogram, "pound");
    private RealType meHgt;
    private RealType meWgt;
    private RealType enHgt = RealType.getRealType("EnglishHeight", this.foot, null);
    private RealType enWgt = RealType.getRealType("EnglishWeight", this.pound, null);
    private FakeCoordinateSystem cSys1D;
    private FakeCoordinateSystem cSys2D;
    private FakeCoordinateSystem cSys3D;
    private Unit[] enUnits1D;
    private Unit[] enUnits2D;
    private Unit[] enUnits3D;
    private RealTupleType tuple1D;
    private RealTupleType tuple2D;
    private RealTupleType tuple3D;

    FakeData() throws VisADException {
        this.meHgt = RealType.getRealType("MetricHeight", (Unit)SI.meter, null);
        this.meWgt = RealType.getRealType("MetricWeight", (Unit)SI.kilogram, null);
        this.enUnits1D = new Unit[]{this.foot};
        this.cSys1D = new FakeCoordinateSystem(new RealTupleType(this.meHgt), this.enUnits1D);
        this.tuple1D = new RealTupleType(this.meHgt, (CoordinateSystem)this.cSys1D, null);
        this.enUnits2D = new Unit[]{this.foot, this.pound};
        this.cSys2D = new FakeCoordinateSystem(new RealTupleType(this.meHgt, this.meWgt), this.enUnits2D);
        this.tuple2D = new RealTupleType(this.meHgt, this.meWgt, this.cSys2D, null);
        this.enUnits3D = new Unit[]{this.foot, this.pound, SI.second};
        this.cSys3D = new FakeCoordinateSystem(new RealTupleType(this.meHgt, this.meWgt, RealType.Time), this.enUnits3D);
        this.tuple3D = new RealTupleType(this.meHgt, this.meWgt, RealType.Time, this.cSys3D, null);
    }

    private void fakeFunctions(ArrayList list) {
        try {
            FunctionType ft = new FunctionType(RealType.Time, this.enHgt);
            Integer1DSet set = new Integer1DSet((MathType)RealType.Time, 15);
            list.add(new FieldImpl(ft, set));
            list.add(new FlatField(ft, set));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Function");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGriddedSets(ArrayList list) {
        float[][] data = new float[][]{{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}};
        int[] lengths = new int[]{10};
        ErrorEstimate[] errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
        try {
            list.add(new GriddedSet(RealType.Altitude, data, lengths));
            list.add(new GriddedSet(this.tuple1D, data, lengths, this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build GriddedSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        this.fakeGridded1DSets(list);
        this.fakeGridded2DSets(list);
        this.fakeGridded3DSets(list);
        this.fakeGriddedNDSets(list);
    }

    private void fakeGridded1DSets(ArrayList list) {
        float[][] data = new float[][]{{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}};
        double[][] dblData = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0}};
        ErrorEstimate[] errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
        try {
            list.add(new Gridded1DSet((MathType)RealType.Altitude, (float[][])data, data[0].length));
            list.add(new Gridded1DSet((MathType)this.tuple1D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded1DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Gridded1DDoubleSet((MathType)RealType.Altitude, (float[][])data, data[0].length));
            list.add(new Gridded1DDoubleSet((MathType)this.tuple1D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errors));
            list.add(new Gridded1DDoubleSet((MathType)RealType.Altitude, dblData, dblData[0].length));
            list.add(new Gridded1DDoubleSet((MathType)this.tuple1D, dblData, dblData[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded1DDoubleSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Linear1DSet(-1.23, 4.56, 10));
            list.add(new Linear1DSet((MathType)RealType.TimeInterval, 1.35, 7.9, 11));
            list.add(new Linear1DSet((MathType)this.tuple1D, 3.21, 6.66, 5, this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear1DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Integer1DSet(15));
            list.add(new Integer1DSet((MathType)RealType.TimeInterval, 7));
            list.add(new Integer1DSet(this.tuple1D, 5, this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Integer1DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGridded2DSets(ArrayList list) {
        Linear1DSet[] lset;
        float[][] data = new float[][]{{0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}, {0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}};
        double[][] dblData = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, {11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0}};
        ErrorEstimate[] errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound)};
        try {
            lset = new Linear1DSet[]{new Linear1DSet(1.0, 4.0, 3), new Linear1DSet(5.0, 8.0, 4)};
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear1DSet arguments for 2D set tests");
            ve.printStackTrace();
            lset = null;
        }
        try {
            list.add(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])data, data[0].length));
            list.add(new Gridded2DSet((MathType)this.tuple2D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            list.add(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, data, 3, 4));
            list.add(new Gridded2DSet((MathType)this.tuple2D, (float[][])data, 3, 4, this.cSys2D, this.enUnits2D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded2DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, (float[][])data, data[0].length));
            list.add(new Gridded2DDoubleSet((MathType)this.tuple2D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            list.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, data, 3, 4));
            list.add(new Gridded2DDoubleSet((MathType)this.tuple2D, (float[][])data, 3, 4, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            list.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, dblData, dblData[0].length));
            list.add(new Gridded2DDoubleSet((MathType)this.tuple2D, dblData, dblData[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            list.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, dblData, 4, 3));
            list.add(new Gridded2DDoubleSet((MathType)this.tuple2D, (double[][])dblData, 4, 3, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded2DDoubleSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Linear2DSet(-1.23, 4.56, 5, 7.89, 12.34, 5));
            list.add(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, 1.0, 5.0, 5, 1.0, 8.0, 8));
            list.add(new Linear2DSet(this.tuple2D, 3.0, 9.0, 3, 3.0, 7.0, 4, this.cSys2D, this.enUnits2D, errors));
            if (lset != null) {
                list.add(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, lset));
                list.add(new Linear2DSet((MathType)this.tuple2D, lset, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            }
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear2DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Integer2DSet(5, 3));
            list.add(new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, 7, 2));
            list.add(new Integer2DSet((MathType)this.tuple2D, 5, 4, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
            Integer1DSet[] iset = new Integer1DSet[]{new Integer1DSet(5), new Integer1DSet(4)};
            list.add(new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, iset));
            list.add(new Integer2DSet((MathType)this.tuple2D, iset, (CoordinateSystem)this.cSys2D, this.enUnits2D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Integer2DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, 4.0, 6.0, 5, 1.23, 4.56, 5));
            if (lset != null) {
                list.add(new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, lset));
            }
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build LinearLatLonSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGridded3DSets(ArrayList list) {
        Linear1DSet[] lset;
        float[][] data = new float[][]{{0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}, {0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f}, {0.2f, 0.4f, 0.6f, 0.8f, 1.0f, 1.2f, 1.4f, 1.6f, 1.8f, 2.0f, 2.2f, 2.4f}};
        double[][] dblData = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, {11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0}, {4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5}};
        ErrorEstimate[] errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound), new ErrorEstimate(0.9, 0.9, (Unit)SI.second)};
        try {
            lset = new Linear1DSet[]{new Linear1DSet(1.0, 4.0, 3), new Linear1DSet(5.0, 8.0, 4), new Linear1DSet(9.0, 123.4, 5)};
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear1DSet arguments for 3D set tests");
            ve.printStackTrace();
            lset = null;
        }
        try {
            list.add(new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, (float[][])data, data[0].length));
            list.add(new Gridded3DSet((MathType)this.tuple3D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            list.add(new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, data, 3, 4));
            list.add(new Gridded3DSet((MathType)this.tuple3D, (float[][])data, 3, 4, this.cSys3D, this.enUnits3D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded3DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, (float[][])data, data[0].length));
            list.add(new Gridded3DDoubleSet((MathType)this.tuple3D, (float[][])data, data[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            list.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, data, 3, 4));
            list.add(new Gridded3DDoubleSet((MathType)this.tuple3D, (float[][])data, 3, 4, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            list.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, dblData, dblData[0].length));
            list.add(new Gridded3DDoubleSet((MathType)this.tuple3D, dblData, dblData[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            list.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, dblData, 4, 3));
            list.add(new Gridded3DDoubleSet((MathType)this.tuple3D, (double[][])dblData, 4, 3, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Gridded3DDoubleSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Linear3DSet(-1.23, 4.56, 5, 7.89, 12.34, 5, 6.7, 8.9, 5));
            list.add(new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, 1.0, 5.0, 4, 1.0, 7.0, 7, 1.0, 9.0, 4));
            list.add(new Linear3DSet(this.tuple3D, 3.0, 9.0, 3, 3.0, 7.0, 4, 3.0, 5.0, 5, this.cSys3D, this.enUnits3D, errors));
            if (lset != null) {
                list.add(new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, lset));
                list.add(new Linear3DSet((MathType)this.tuple3D, lset, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            }
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear3DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Integer3DSet(5, 3, 1));
            list.add(new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, 7, 2, 4));
            list.add(new Integer3DSet((MathType)this.tuple3D, 5, 4, 3, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
            Integer1DSet[] iset = new Integer1DSet[]{new Integer1DSet(5), new Integer1DSet(4), new Integer1DSet(3)};
            list.add(new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, iset));
            list.add(new Integer3DSet((MathType)this.tuple3D, iset, (CoordinateSystem)this.cSys3D, this.enUnits3D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Integer3DSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGriddedNDSets(ArrayList list) {
        Linear1DSet[] lset;
        RealTupleType tuple5D;
        FakeCoordinateSystem cSys5D;
        RealTupleType tmpTuple;
        Unit[] enUnits5D = new Unit[]{this.foot, this.pound, SI.second, CommonUnit.degree, CommonUnit.degree};
        RealType[] typeList = new RealType[]{this.meHgt, this.meWgt, RealType.Time, RealType.Latitude, RealType.Longitude};
        try {
            tmpTuple = new RealTupleType(typeList);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build temporary 5D tuple type");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            cSys5D = new FakeCoordinateSystem(tmpTuple, enUnits5D);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build 5D coordinate system");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            tuple5D = new RealTupleType(typeList, (CoordinateSystem)cSys5D, null);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build 5D tuple type");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        double[] firsts = new double[]{1.0, 0.0, 2.0, 123.0, 42.0};
        double[] lasts = new double[]{2.0, 100.0, 16.0, 246.0, 49.0};
        int[] lengths = new int[]{3, 2, 3, 2, 3};
        ErrorEstimate[] errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound), new ErrorEstimate(0.9, 0.9, (Unit)SI.second), new ErrorEstimate(3.14, 1.59, CommonUnit.degree), new ErrorEstimate(5.2, 8.0, CommonUnit.degree)};
        try {
            lset = new Linear1DSet[]{new Linear1DSet(1.0, 2.0, 3), new Linear1DSet(0.0, 100.0, 2), new Linear1DSet(2.0, 16.4, 3), new Linear1DSet(123.0, 246.0, 2), new Linear1DSet(42.0, 49.0, 3)};
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear1DSet arguments for ND set tests");
            ve.printStackTrace();
            lset = null;
        }
        try {
            list.add(new LinearNDSet((MathType)tuple5D, firsts, lasts, lengths));
            list.add(new LinearNDSet((MathType)tuple5D, firsts, lasts, lengths, cSys5D, enUnits5D, errors));
            list.add(new LinearNDSet((MathType)tuple5D, lset));
            list.add(new LinearNDSet((MathType)tuple5D, lset, (CoordinateSystem)cSys5D, enUnits5D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build LinearNDSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeIrregularSets(ArrayList list) {
        ErrorEstimate[] errors;
        float[][] data;
        DelaunayFast del;
        try {
            del = new DelaunayFast(new float[][]{{1.0f, 2.0f, 3.0f}, {1.0f, 2.0f, 3.0f}});
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build DelaunayFast");
            ve.printStackTrace();
            del = null;
        }
        try {
            data = new float[][]{{1.23f, 4.56f, 7.89f}};
            errors = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
            list.add(new IrregularSet((MathType)RealType.Altitude, data));
            list.add(new IrregularSet(RealType.XAxis, data, del));
            list.add(new IrregularSet(this.tuple1D, data, 1, this.cSys1D, this.enUnits1D, errors, del));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build IrregularSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new Irregular1DSet((MathType)RealTupleType.Time1DTuple, data));
            list.add(new Irregular1DSet((MathType)this.tuple1D, data, (CoordinateSystem)this.cSys1D, this.enUnits1D, errors));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Irregular1DSet");
            ve.printStackTrace();
            System.exit(1);
        }
        try {
            data = new float[][]{{1.23f, 4.56f, 7.89f}, {9.87f, 6.54f, 3.21f}};
            errors = new ErrorEstimate[]{new ErrorEstimate(4.56, 0.05, this.foot), new ErrorEstimate(7.89, 0.67, this.pound)};
            list.add(new Irregular2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, data));
            list.add(new Irregular2DSet(this.tuple2D, data, this.cSys2D, this.enUnits2D, errors, del));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Irregular2DSet");
            ve.printStackTrace();
            System.exit(1);
        }
        try {
            data = new float[][]{{1.23f, 4.56f, 7.89f}, {9.87f, 6.54f, 3.21f}, {5.43f, 2.19f, 8.76f}};
            errors = new ErrorEstimate[]{new ErrorEstimate(4.56, 0.05, this.foot), new ErrorEstimate(7.89, 0.67, this.pound), new ErrorEstimate(1.23, 1.23, (Unit)SI.second)};
            list.add(new Irregular3DSet((MathType)RealTupleType.SpatialEarth3DTuple, data));
            list.add(new Irregular3DSet(this.tuple3D, data, this.cSys3D, this.enUnits3D, errors, del));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Irregular3DSet");
            ve.printStackTrace();
            System.exit(1);
        }
    }

    private void fakeSampledSets(ArrayList list) {
        UnionSet uset;
        Linear1DSet lset;
        Integer1DSet iset;
        try {
            Real[] singles = new Real[]{new Real(0.123), new Real(1.234)};
            list.add(new SingletonSet(new RealTuple(singles)));
            singles = new Real[]{new Real(RealType.Time, 6.66), new Real(RealType.Time, 9.99, SI.second)};
            list.add(new SingletonSet(new RealTuple(singles)));
        }
        catch (RemoteException re) {
            System.err.println("Couldn't build SingletonSet");
            re.printStackTrace();
            System.exit(1);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build SingletonSet");
            ve.printStackTrace();
            System.exit(1);
        }
        try {
            iset = new Integer1DSet(10);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Integer1DSet for UnionSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            lset = new Linear1DSet(-15.0, 15.0, 10);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build Linear1DSet for UnionSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        SampledSet[] sets = new SampledSet[]{iset, lset};
        try {
            list.add(new UnionSet(sets));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build UnionSet");
            ve.printStackTrace();
            System.exit(1);
        }
        sets = new SampledSet[2];
        int[] lengths = new int[]{3};
        try {
            sets[0] = new GriddedSet(RealType.TimeInterval, new float[][]{{0.0f, 1.0f, 2.0f}}, lengths);
            sets[1] = new GriddedSet(RealType.TimeInterval, new float[][]{{6.0f, 5.0f, 4.0f}}, lengths);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build GriddedSets for ProductSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            uset = new UnionSet(sets);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build second UnionSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        list.add(uset);
        try {
            list.add(uset.product(sets[0]));
        }
        catch (VisADException ve) {
            System.err.println("Couldn't get product of UnionSet");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        this.fakeGriddedSets(list);
        this.fakeIrregularSets(list);
    }

    private void fakeSets(ArrayList list) {
        RealTupleType rttHgt;
        try {
            rttHgt = new RealTupleType(new RealType[]{this.meHgt}, (CoordinateSystem)this.cSys1D, null);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't build RealTupleType for height!");
            ve.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            list.add(new DoubleSet(RealType.Time));
            list.add(new FloatSet(rttHgt, this.cSys1D, null));
            list.add(new FloatSet(rttHgt, this.cSys1D, new Unit[]{SI.meter}));
            list.add(new FloatSet(RealType.XAxis));
            list.add(new FloatSet(rttHgt, this.cSys1D, null));
            list.add(new FloatSet(rttHgt, this.cSys1D, new Unit[]{SI.meter}));
            list.add(new List1DSet(new float[]{1.1f, 2.2f, 3.3f}, rttHgt, this.cSys1D, null));
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        this.fakeSampledSets(list);
    }

    private void fakeTuples(ArrayList list) {
        TextType tt;
        try {
            tt = new TextType("Note");
        }
        catch (VisADException ve) {
            tt = TextType.Generic;
        }
        MathType[] mtypes = new MathType[]{RealType.Latitude, RealType.Longitude, tt};
        try {
            list.add(new Tuple(new TupleType(mtypes), new Data[]{new Real(RealType.Latitude, -60.0), new Real(RealType.Longitude, 60.0), new Text(tt, "Some text")}));
        }
        catch (RemoteException remoteException) {
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        try {
            Real[] vals = new Real[]{new Real(this.meHgt, 4.56), new Real(this.meWgt, 1.23)};
            list.add(new RealTuple(this.tuple2D, vals, this.cSys2D));
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
    }

    DataImpl[] getList() {
        ArrayList<Scalar> list = new ArrayList<Scalar>();
        list.add(new Text("g>a\"r&b<a'ge"));
        try {
            list.add(new Text(new TextType("'Ru&de=>Ty<pe\"")));
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        list.add(new Real(RealType.XAxis, 123.456));
        try {
            list.add(new Real(RealType.Altitude, 123.456, (Unit)SI.meter, 43.21));
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        try {
            list.add(new Real(RealType.TimeInterval, Double.NaN, (Unit)SI.second, 43.21));
        }
        catch (VisADException ve) {
            ve.printStackTrace();
        }
        this.fakeTuples(list);
        this.fakeSets(list);
        this.fakeFunctions(list);
        DataImpl[] dataList = new DataImpl[list.size()];
        for (int i = 0; i < dataList.length; ++i) {
            dataList[i] = (DataImpl)list.get(i);
        }
        return dataList;
    }
}

