/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayInterruptException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGroup;
import visad.VisADSwitch;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.ShadowFunctionTypeJ2D;
import visad.java2d.ShadowRealTupleTypeJ2D;
import visad.java2d.ShadowRealTypeJ2D;
import visad.java2d.ShadowSetTypeJ2D;
import visad.java2d.ShadowTextTypeJ2D;
import visad.java2d.ShadowTupleTypeJ2D;
import visad.java2d.VisADCanvasJ2D;

public abstract class RendererJ2D
extends DataRenderer {
    VisADGroup swParent;
    VisADSwitch swit;

    @Override
    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (this.getDisplay() != null || this.getLinks() != null) {
            throw new DisplayException("RendererJ2D.setLinks: already set");
        }
        if (!(d instanceof DisplayImplJ2D)) {
            throw new DisplayException("RendererJ2D.setLinks: must be DisplayImplJ2D");
        }
        this.setDisplay(d);
        this.setDisplayRenderer(d.getDisplayRenderer());
        this.setLinks(links);
        this.swParent = new VisADGroup();
        this.swit = new VisADSwitch();
        VisADGroup empty = new VisADGroup();
        this.swit.addChild(this.swParent);
        this.swit.addChild(empty);
        this.swit.setWhichChild(0);
        this.addSwitch((DisplayRendererJ2D)this.getDisplayRenderer(), this.swit);
        this.toggle(this.getEnabled());
    }

    @Override
    public void toggle(boolean on) {
        if (this.swit != null) {
            this.swit.setWhichChild(on ? 0 : 1);
            VisADCanvasJ2D canvas = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            canvas.scratchImages();
        }
        super.toggle(on);
    }

    @Override
    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowFunctionTypeJ2D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowRealTupleType(RealTupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowRealTupleTypeJ2D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowRealType(RealType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowRealTypeJ2D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowSetTypeJ2D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowTextType(TextType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowTextTypeJ2D(type, link, parent);
    }

    @Override
    public ShadowType makeShadowTupleType(TupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowTupleTypeJ2D(type, link, parent);
    }

    abstract void addSwitch(DisplayRendererJ2D var1, VisADGroup var2) throws VisADException;

    @Override
    public boolean doAction() throws VisADException, RemoteException {
        boolean all_feasible = this.get_all_feasible();
        boolean any_changed = this.get_any_changed();
        boolean any_transform_control = this.get_any_transform_control();
        boolean scratch = false;
        if (all_feasible && (any_changed || any_transform_control)) {
            VisADGroup branch;
            this.clearAVControls();
            try {
                branch = this.doTransform();
            }
            catch (OutOfMemoryError e) {
                try {
                    if (this.swParent.numChildren() > 0) {
                        this.swParent.removeChild(0);
                    }
                    branch = null;
                    Runtime.getRuntime().gc();
                    Runtime.getRuntime().runFinalization();
                    branch = this.doTransform();
                }
                catch (BadMappingException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (UnimplementedException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (RemoteException ee) {
                    this.addException(ee);
                    branch = null;
                }
                catch (DisplayInterruptException ee) {
                    branch = null;
                }
            }
            catch (BadMappingException e) {
                this.addException(e);
                branch = null;
            }
            catch (UnimplementedException e) {
                this.addException(e);
                branch = null;
            }
            catch (RemoteException e) {
                this.addException(e);
                branch = null;
            }
            catch (DisplayInterruptException e) {
                branch = null;
            }
            if (branch != null) {
                this.swParent.setChild(branch, 0);
                scratch = true;
            } else {
                if (this.swParent.numChildren() > 0) {
                    this.swParent.removeChild(0);
                    scratch = true;
                }
                all_feasible = false;
                this.set_all_feasible(all_feasible);
            }
        } else {
            DataDisplayLink[] links = this.getLinks();
            for (int i = 0; i < links.length; ++i) {
                links[i].clearData();
            }
        }
        if (scratch) {
            ((DisplayImplJ2D)this.getDisplay()).setScratch();
        }
        return all_feasible && (any_changed || any_transform_control);
    }

    @Override
    public void clearBranch() {
        if (this.swParent.numChildren() > 0) {
            this.swParent.removeChild(0);
            VisADCanvasJ2D canvas = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            canvas.scratchImages();
        }
    }

    @Override
    public void clearScene() {
        this.swParent.detach();
        ((DisplayRendererJ2D)this.getDisplayRenderer()).clearScene(this);
        VisADCanvasJ2D canvas = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
        canvas.scratchImages();
        super.clearScene();
    }

    public abstract VisADGroup doTransform() throws VisADException, RemoteException;
}

