/*
 * Decompiled with CFR 0.152.
 */
package visad.sounder;

import java.rmi.RemoteException;
import visad.CellImpl;
import visad.DataReferenceImpl;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.units.NoSuchUnitException;
import visad.data.netcdf.units.ParseException;
import visad.data.netcdf.units.Parser;
import visad.sounder.Sounding;
import visad.sounder.Spectrum;

public abstract class SounderInstrument {
    double[][] model_parms;
    RealType[] model_parm_types;
    DataReferenceImpl[] parm_refs;
    int n_parms;

    public SounderInstrument(String[] names, String[] units, double[] parms) throws VisADException, RemoteException {
        int ii;
        this.n_parms = parms.length;
        if (names.length != this.n_parms || units.length != this.n_parms) {
            throw new VisADException("# of names, units, parms must be equal");
        }
        this.model_parm_types = new RealType[this.n_parms];
        this.model_parms = new double[1][this.n_parms];
        this.parm_refs = new DataReferenceImpl[this.n_parms];
        CellImpl update_cell = new CellImpl(){

            @Override
            public void doAction() throws VisADException, RemoteException {
                for (int ii = 0; ii < SounderInstrument.this.n_parms; ++ii) {
                    SounderInstrument.this.model_parms[0][ii] = ((Real)SounderInstrument.this.parm_refs[ii].getData()).getValue();
                }
            }
        };
        for (ii = 0; ii < this.n_parms; ++ii) {
            Unit u = null;
            try {
                u = Parser.parse(units[ii]);
            }
            catch (NoSuchUnitException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.model_parm_types[ii] = new RealType(names[ii], u, null);
            this.model_parms[0][ii] = parms[ii];
            this.parm_refs[ii] = new DataReferenceImpl(names[ii]);
            this.parm_refs[ii].setData(new Real(this.model_parm_types[ii], this.model_parms[0][ii]));
        }
        for (ii = 0; ii < this.n_parms; ++ii) {
            update_cell.addReference(this.parm_refs[ii]);
        }
    }

    public DataReferenceImpl[] getParamReferences() {
        return this.parm_refs;
    }

    public Sounding retrieval(Spectrum spectrum, Sounding sounding) {
        float[][] radiances = null;
        float[][] rtvl = this.computeRetrieval(radiances, this.model_parms);
        return null;
    }

    public Sounding retrieval(Spectrum spectrum) {
        return this.retrieval(spectrum, null);
    }

    public Spectrum foward(Sounding sounding) {
        float[][] rtvl = null;
        float[][] spec = this.computeFoward(rtvl, this.model_parms);
        return null;
    }

    abstract Sounding makeSounding() throws VisADException, RemoteException;

    abstract Sounding makeSounding(Sounding var1);

    abstract Spectrum makeSpectrum() throws VisADException, RemoteException;

    abstract float[][] computeRetrieval(float[][] var1, double[][] var2);

    abstract float[][] computeFoward(float[][] var1, double[][] var2);
}

