/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.util.Slider;
import visad.util.SliderChangeEvent;

public class BarSlider
extends Slider
implements MouseListener,
MouseMotionListener {
    private float upper;
    private float lower;
    private float val;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private int oldxval;

    public BarSlider() {
        this(-1.0f, 1.0f, 0.0f);
    }

    public BarSlider(float lower, float upper, float initial) {
        if (lower > initial) {
            throw new IllegalArgumentException("BarSlider: lower bound is greater than initial value");
        }
        if (initial > upper) {
            throw new IllegalArgumentException("BarSlider: initial value is greater than the upper bound");
        }
        this.upper = upper;
        this.lower = lower;
        this.val = initial;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Visad Bar Slider");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        BarSlider b = new BarSlider();
        frame.add(b);
        frame.setSize(b.getPreferredSize());
        frame.setVisible(true);
    }

    @Override
    public float getMinimum() {
        return this.lower;
    }

    @Override
    public synchronized void setMinimum(float value) {
        if (value > this.val || value == this.val && value == this.upper) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new minimum value greater than the current value");
        }
        this.lower = value;
        this.notifyListeners(new SliderChangeEvent(2, value));
        this.repaint();
    }

    @Override
    public float getMaximum() {
        return this.upper;
    }

    @Override
    public synchronized void setMaximum(float value) {
        if (value < this.val || value == this.val && value == this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new maximum value less than the current value");
        }
        this.upper = value;
        this.notifyListeners(new SliderChangeEvent(3, value));
        this.repaint();
    }

    @Override
    public float getValue() {
        return this.val;
    }

    @Override
    public synchronized void setValue(float value) {
        if (value > this.upper || value < this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new value out of slider range");
        }
        this.val = value;
        this.notifyListeners(new SliderChangeEvent(1, value));
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 16);
        }
        return this.prefSize;
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.prefSize = dim;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 16);
        }
        return this.maxSize;
    }

    @Override
    public void setMaximumSize(Dimension dim) {
        this.maxSize = dim;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(40, 16);
        }
        return this.minSize;
    }

    @Override
    public void setMinimumSize(Dimension dim) {
        this.minSize = dim;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updatePosition(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updatePosition(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void updatePosition(MouseEvent e) {
        int x = e.getX();
        if (x < 0) {
            x = 0;
        }
        if (x >= this.getBounds().width) {
            x = this.getBounds().width - 1;
        }
        float dist = (float)x / (float)(this.getBounds().width - 1);
        this.setValue(this.lower + dist * (this.upper - this.lower));
    }

    @Override
    public void update(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(this.oldxval - 2, 0, 5, this.getBounds().height - 1);
        g.setColor(Color.gray);
        g.fillRect(this.oldxval - 2, this.getBounds().height / 2 - 1, 6, 3);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawRect(xval - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = xval;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g.setColor(Color.gray);
        g.fillRect(0, this.getBounds().height / 2 - 1, this.getBounds().width, 3);
        g.setColor(Color.white);
        int xval = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        g.drawRect(xval - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = xval;
    }
}

