/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.HersheyFont;

public class TextControlWidget
extends JPanel {
    private String[] javaFontNames = null;
    private String[] hersheyFontNames = null;
    private String[] visadFontNames = null;
    private String textToPreview = "VisAD";
    private TextControl previewDisplayTC = null;
    private TextControl textControl = null;
    private DisplayImpl display = null;
    private ScalarMap textMap = null;
    private FieldImpl textField = null;
    private TextType textType = null;
    private JLabel jLabel8;
    private JLabel jLabel4;
    private JComboBox vertJustificationJComboBox;
    private JTextField offsetYField;
    private JTextField offsetZField;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JRadioButton labelFontJRadioButton;
    private JTextField textOrientationField;
    private JLabel jLabel2;
    private JScrollPane jScrollPane4;
    private JLabel jLabel9;
    private JScrollPane jScrollPane2;
    private JPanel fontTypeJPanel;
    private JRadioButton hersheyFontjRadioButton;
    private JPanel displayTextToPreview;
    private JPanel leftPanel;
    private JList fontNamesJList;
    private JComboBox horizJustificationJComboBox;
    private JList fontStylesJList;
    private JCheckBox autoSizeJCheckBox;
    private JPanel previewPanel;
    private JPanel fontSelectionJPanel;
    private JRadioButton javaFontJRadioButton;
    private JLabel jLabel7;
    private JTextField offsetXField;
    private JPanel textPanelAttributes;
    private JList fontSizesJList;
    private JTextField characterRotationField;
    private JLabel jLabel6;
    private JTextField scaleTextField;
    private ButtonGroup fontTypeButtonGroup;
    private JTextField textToPreviewField;
    private JScrollPane jScrollPane3;
    private JPanel rightPanel;
    private JPanel bottomPanel;
    private JLabel jLabel5;

    public TextControlWidget(TextControl aTextControl) throws RemoteException, VisADException {
        this.initComponents();
        this.javaFontNames = this.getJavaFontNames();
        this.hersheyFontNames = TextControlWidget.getHersheyFontNames();
        this.visadFontNames = new String[]{"VisAD Default"};
        this.fontNamesJList.setListData(this.javaFontNames);
        this.fontNamesJList.setSelectedIndex(0);
        String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "24", "36", "48", "72"};
        this.fontSizesJList.setListData(sizes);
        this.fontSizesJList.setSelectedIndex(7);
        String[] styles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
        this.fontStylesJList.setListData(styles);
        this.fontStylesJList.setSelectedIndex(0);
        this.textToPreviewField.setText(this.textToPreview);
        this.textControl = aTextControl;
        if (this.textControl == null) {
            this.textControl = new TextControl(null);
        }
        this.setGUIControls(this.textControl);
        this.setupPreviewDisplay();
        if (this.display == null) {
            System.out.println("Display is null!");
        }
        this.previewDisplayTC = (TextControl)this.textMap.getControl();
        this.updateTextControl();
        this.displayTextToPreview.add(this.display.getComponent());
    }

    private void initComponents() {
        this.fontTypeButtonGroup = new ButtonGroup();
        this.fontTypeJPanel = new JPanel();
        this.javaFontJRadioButton = new JRadioButton();
        this.hersheyFontjRadioButton = new JRadioButton();
        this.labelFontJRadioButton = new JRadioButton();
        this.fontSelectionJPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fontNamesJList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.fontStylesJList = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.fontSizesJList = new JList();
        this.previewPanel = new JPanel();
        this.textToPreviewField = new JTextField();
        this.displayTextToPreview = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.textPanelAttributes = new JPanel();
        this.leftPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.textOrientationField = new JTextField();
        this.jLabel5 = new JLabel();
        this.characterRotationField = new JTextField();
        this.jLabel8 = new JLabel();
        this.scaleTextField = new JTextField();
        this.autoSizeJCheckBox = new JCheckBox();
        this.rightPanel = new JPanel();
        this.horizJustificationJComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.vertJustificationJComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.offsetXField = new JTextField();
        this.offsetYField = new JTextField();
        this.offsetZField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.fontTypeJPanel.setLayout(new FlowLayout(0));
        this.javaFontJRadioButton.setSelected(true);
        this.javaFontJRadioButton.setText("Java font");
        this.fontTypeButtonGroup.add(this.javaFontJRadioButton);
        this.javaFontJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.javaFontJRadioButtonActionPerformed(evt);
            }
        });
        this.fontTypeJPanel.add(this.javaFontJRadioButton);
        this.hersheyFontjRadioButton.setText("Hershery font");
        this.fontTypeButtonGroup.add(this.hersheyFontjRadioButton);
        this.hersheyFontjRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.hersheyFontjRadioButtonActionPerformed(evt);
            }
        });
        this.fontTypeJPanel.add(this.hersheyFontjRadioButton);
        this.labelFontJRadioButton.setText("VisAD font");
        this.fontTypeButtonGroup.add(this.labelFontJRadioButton);
        this.labelFontJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.labelFontJRadioButtonActionPerformed(evt);
            }
        });
        this.fontTypeJPanel.add(this.labelFontJRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.fontTypeJPanel, gridBagConstraints);
        this.fontSelectionJPanel.setLayout(new GridBagLayout());
        this.fontSelectionJPanel.setMinimumSize(new Dimension(200, 70));
        this.fontSelectionJPanel.setPreferredSize(new Dimension(360, 100));
        this.jLabel1.setText("Font Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.fontSelectionJPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.fontSelectionJPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.fontSelectionJPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(160, 40));
        this.jScrollPane1.setPreferredSize(new Dimension(160, 40));
        this.fontNamesJList.setBorder(new CompoundBorder());
        this.fontNamesJList.setSelectionMode(0);
        this.fontNamesJList.setSelectedIndex(1);
        this.fontNamesJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TextControlWidget.this.fontNamesJListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fontNamesJList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.fontSelectionJPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setMaximumSize(new Dimension(0, 0));
        this.jScrollPane2.setMinimumSize(new Dimension(90, 40));
        this.jScrollPane2.setPreferredSize(new Dimension(100, 40));
        this.fontStylesJList.setSelectionMode(0);
        this.fontStylesJList.setSelectedIndex(0);
        this.fontStylesJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TextControlWidget.this.fontStylesJListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.fontStylesJList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.fontSelectionJPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(100, 40));
        this.jScrollPane3.setPreferredSize(new Dimension(60, 40));
        this.fontSizesJList.setSelectionMode(0);
        this.fontSizesJList.setSelectedIndex(3);
        this.fontSizesJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TextControlWidget.this.fontSizesJListValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.fontSizesJList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.fontSelectionJPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.add((Component)this.fontSelectionJPanel, gridBagConstraints);
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewPanel.setBorder(new TitledBorder("Preview"));
        this.previewPanel.setMinimumSize(new Dimension(56, 192));
        this.textToPreviewField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.textToPreviewFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.previewPanel.add((Component)this.textToPreviewField, gridBagConstraints);
        this.displayTextToPreview.setLayout(new BorderLayout());
        this.displayTextToPreview.setBorder(new EtchedBorder());
        this.displayTextToPreview.setPreferredSize(new Dimension(300, 300));
        this.displayTextToPreview.add((Component)this.jScrollPane4, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.previewPanel.add((Component)this.displayTextToPreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.add((Component)this.previewPanel, gridBagConstraints);
        this.textPanelAttributes.setLayout(new GridBagLayout());
        this.leftPanel.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Text Orientation:");
        this.jLabel4.setPreferredSize(new Dimension(120, 16));
        this.jLabel4.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.textOrientationField.setText("0");
        this.textOrientationField.setPreferredSize(new Dimension(50, 20));
        this.textOrientationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.textOrientationFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.textOrientationField, gridBagConstraints);
        this.jLabel5.setText("Character Rotation:");
        this.jLabel5.setPreferredSize(new Dimension(40, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.characterRotationField.setText("0");
        this.characterRotationField.setPreferredSize(new Dimension(50, 20));
        this.characterRotationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.characterRotationFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.characterRotationField, gridBagConstraints);
        this.jLabel8.setText("Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.scaleTextField.setText("1.0");
        this.scaleTextField.setPreferredSize(new Dimension(50, 20));
        this.scaleTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.scaleTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.scaleTextField, gridBagConstraints);
        this.autoSizeJCheckBox.setText("auto size");
        this.autoSizeJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.autoSizeJCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.leftPanel.add((Component)this.autoSizeJCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.textPanelAttributes.add((Component)this.leftPanel, gridBagConstraints);
        this.rightPanel.setLayout(new GridBagLayout());
        this.rightPanel.setMinimumSize(new Dimension(144, 80));
        this.rightPanel.setPreferredSize(new Dimension(220, 56));
        this.horizJustificationJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Left", "Center", "Right"}));
        this.horizJustificationJComboBox.setPreferredSize(new Dimension(90, 25));
        this.horizJustificationJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.horizJustificationJComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.rightPanel.add((Component)this.horizJustificationJComboBox, gridBagConstraints);
        this.jLabel7.setText("Horizontal justification:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.rightPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setText("Vertical justification:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.rightPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.vertJustificationJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Bottom", "Center", "Top"}));
        this.vertJustificationJComboBox.setPreferredSize(new Dimension(90, 25));
        this.vertJustificationJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.vertJustificationJComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.rightPanel.add((Component)this.vertJustificationJComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.textPanelAttributes.add((Component)this.rightPanel, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.jLabel9.setText("Offsets ([x, y, z]):");
        this.bottomPanel.add((Component)this.jLabel9, new GridBagConstraints());
        this.offsetXField.setText("0");
        this.offsetXField.setPreferredSize(new Dimension(50, 20));
        this.offsetXField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.offsetXFieldActionPerformed(evt);
            }
        });
        this.bottomPanel.add((Component)this.offsetXField, new GridBagConstraints());
        this.offsetYField.setText("0");
        this.offsetYField.setPreferredSize(new Dimension(50, 20));
        this.offsetYField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.offsetYFieldActionPerformed(evt);
            }
        });
        this.bottomPanel.add((Component)this.offsetYField, new GridBagConstraints());
        this.offsetZField.setText("0");
        this.offsetZField.setPreferredSize(new Dimension(50, 20));
        this.offsetZField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextControlWidget.this.offsetZFieldActionPerformed(evt);
            }
        });
        this.bottomPanel.add((Component)this.offsetZField, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.textPanelAttributes.add((Component)this.bottomPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.add((Component)this.textPanelAttributes, gridBagConstraints);
    }

    private void vertJustificationJComboBoxActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void autoSizeJCheckBoxActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void labelFontJRadioButtonActionPerformed(ActionEvent evt) {
        this.fontNamesJList.setListData(this.visadFontNames);
        this.fontNamesJList.setSelectedIndex(0);
        this.fontSelectionJPanel.remove(this.jLabel2);
        this.fontSelectionJPanel.remove(this.jScrollPane2);
        this.fontSelectionJPanel.updateUI();
    }

    private void offsetZFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void offsetYFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void offsetXFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void javaFontJRadioButtonActionPerformed(ActionEvent evt) {
        this.fontNamesJList.setListData(this.javaFontNames);
        this.fontNamesJList.setSelectedIndex(0);
        this.jLabel1.setVisible(true);
        this.jLabel2.setVisible(true);
        this.jLabel3.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.fontSelectionJPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.fontSelectionJPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.fontSelectionJPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.fontSelectionJPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        this.fontSelectionJPanel.updateUI();
    }

    private void textToPreviewFieldActionPerformed(ActionEvent evt) {
        this.textToPreview = this.textToPreviewField.getText();
        try {
            Text datum = new Text(this.textType, this.textToPreview);
            this.textField.setSample(0, (Data)datum);
        }
        catch (RemoteException e) {
            System.out.println("Exception: " + e);
        }
        catch (VisADException e1) {
            System.out.println("Exception: " + e1);
        }
    }

    private void scaleTextFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void characterRotationFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void horizJustificationJComboBoxActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void textOrientationFieldActionPerformed(ActionEvent evt) {
        this.updateTextControl();
    }

    private void fontSizesJListValueChanged(ListSelectionEvent evt) {
        this.updateTextControl();
    }

    private void fontStylesJListValueChanged(ListSelectionEvent evt) {
        this.updateTextControl();
    }

    private void fontNamesJListValueChanged(ListSelectionEvent evt) {
        this.updateTextControl();
    }

    private void hersheyFontjRadioButtonActionPerformed(ActionEvent evt) {
        this.fontNamesJList.setListData(this.hersheyFontNames);
        this.fontNamesJList.setSelectedIndex(0);
        this.fontSelectionJPanel.remove(this.jLabel2);
        this.fontSelectionJPanel.remove(this.jScrollPane2);
        this.fontSelectionJPanel.updateUI();
    }

    private Object getSelectedFont() {
        int selectedIndex = this.fontNamesJList.getSelectedIndex();
        if (selectedIndex == -1) {
            selectedIndex = 0;
            this.fontNamesJList.setSelectedIndex(selectedIndex);
        }
        if (this.javaFontJRadioButton.isSelected()) {
            int size;
            try {
                size = Integer.parseInt((String)this.fontSizesJList.getSelectedValue());
            }
            catch (Exception e) {
                size = 12;
            }
            return new Font((String)this.fontNamesJList.getSelectedValue(), this.fontStylesJList.getSelectedIndex(), size);
        }
        if (this.hersheyFontjRadioButton.isSelected()) {
            return new HersheyFont((String)this.fontNamesJList.getSelectedValue());
        }
        return null;
    }

    private String[] getJavaFontNames() {
        String[] nameArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Vector nameVector = new Vector(nameArray.length);
        Object[] _array = new String[nameVector.size()];
        nameVector.copyInto(_array);
        return nameArray;
    }

    public static String[] getHersheyFontNames() {
        String[] fontNames = null;
        URL url = HersheyFont.class.getResource("futural.jhf");
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String file;
            try {
                file = URLDecoder.decode(url.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                file = url.getFile();
            }
            File f = new File(file);
            f = f.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jhf");
                }
            };
            String[] children = f.list(filter);
            if (children == null) {
                return null;
            }
            fontNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                fontNames[i] = children[i].substring(0, children[i].length() - 4);
            }
        } else if (protocol.equals("jar")) {
            try {
                String name;
                JarURLConnection jarURL = (JarURLConnection)url.openConnection();
                ZipFile zf = new ZipFile(jarURL.getJarFile().getName());
                Enumeration<? extends ZipEntry> e = zf.entries();
                Vector<String> namesVector = new Vector<String>();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    name = ze.getName();
                    if (!name.startsWith("visad/util/") || !name.endsWith(".jhf")) continue;
                    namesVector.add(name.substring(11));
                }
                zf.close();
                if (namesVector.size() == 0) {
                    return null;
                }
                fontNames = new String[namesVector.size()];
                for (int i = 0; i < fontNames.length; ++i) {
                    name = (String)namesVector.elementAt(i);
                    fontNames[i] = name.substring(0, name.length() - 4);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            System.out.println("Cannot locate the HersheyFonts.");
        }
        return fontNames;
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    private void setupPreviewDisplay() throws RemoteException, VisADException {
        this.display = new DisplayImplJ2D("Preview_Display_in_Text_Control_Widget");
        this.textType = TextType.getTextType("Preview_text_type_for_display_in_Text_Control_Widget");
        RealTupleType coord_tuple_type = new RealTupleType(new RealType[]{RealType.Latitude, RealType.Longitude});
        FunctionType text_function = new FunctionType(coord_tuple_type, this.textType);
        Linear2DSet domain = new Linear2DSet((MathType)coord_tuple_type, -120.0, 120.0, 1, -120.0, 120.0, 1);
        this.textField = new FieldImpl(text_function, domain);
        Text datum = new Text(this.textType, this.textToPreview);
        this.textField.setSample(0, (Data)datum);
        this.display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        this.display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        this.textMap = new ScalarMap(this.textType, Display.Text);
        this.display.addMap(this.textMap);
        DataReferenceImpl ref_text_field = new DataReferenceImpl("ref_text_field");
        ref_text_field.setData(this.textField);
        this.display.addReference(ref_text_field, null);
        ProjectionControl pc = this.display.getProjectionControl();
        double[] pcMatrix = pc.getMatrix();
        double percent = 0.9;
        if (pcMatrix.length > 10) {
            pcMatrix[0] = percent;
            pcMatrix[5] = percent;
            pcMatrix[10] = percent;
        } else {
            pcMatrix[0] = percent / 0.64;
            pcMatrix[3] = -percent / 0.64;
            pc.setMatrix(pcMatrix);
        }
    }

    private void setGUIControls(TextControl tc) {
        if (tc == null) {
            return;
        }
        String str = String.valueOf(tc.getScale());
        this.scaleTextField.setText(str);
        if (tc.getJustification() == TextControl.Justification.LEFT) {
            this.horizJustificationJComboBox.setSelectedItem("Left");
        } else if (tc.getJustification() == TextControl.Justification.RIGHT) {
            this.horizJustificationJComboBox.setSelectedItem("Right");
        } else {
            this.horizJustificationJComboBox.setSelectedItem("Center");
        }
        if (tc.getVerticalJustification() == TextControl.Justification.BOTTOM) {
            this.vertJustificationJComboBox.setSelectedItem("Bottom");
        } else if (tc.getVerticalJustification() == TextControl.Justification.TOP) {
            this.vertJustificationJComboBox.setSelectedItem("Top");
        } else {
            this.vertJustificationJComboBox.setSelectedItem("Center");
        }
        str = String.valueOf((int)(tc.getSize() * 12.0));
        this.fontSizesJList.setSelectedValue(str, true);
        Font font = tc.getFont();
        if (font instanceof Font) {
            this.javaFontJRadioButton.setSelected(true);
            switch (font.getStyle()) {
                case 0: {
                    this.fontStylesJList.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.fontStylesJList.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.fontStylesJList.setSelectedIndex(2);
                    break;
                }
                case 3: {
                    this.fontStylesJList.setSelectedIndex(3);
                    break;
                }
                default: {
                    this.fontStylesJList.setSelectedIndex(0);
                }
            }
            this.javaFontJRadioButtonActionPerformed(null);
        } else if (font instanceof HersheyFont) {
            this.hersheyFontjRadioButton.setSelected(true);
            this.hersheyFontjRadioButtonActionPerformed(null);
        } else {
            this.labelFontJRadioButton.setSelected(true);
            this.labelFontJRadioButtonActionPerformed(null);
        }
        str = String.valueOf(tc.getRotation());
        this.textOrientationField.setText(str);
        str = String.valueOf(tc.getCharacterRotation());
        this.characterRotationField.setText(str);
        double[] offsets = tc.getOffset();
        str = String.valueOf(offsets[0]);
        this.offsetXField.setText(str);
        str = String.valueOf(offsets[1]);
        this.offsetYField.setText(str);
        str = String.valueOf(offsets[2]);
        this.offsetZField.setText(str);
        if (tc.getAutoSize()) {
            this.autoSizeJCheckBox.setSelected(true);
        }
    }

    private void updateTextControl() {
        block28: {
            try {
                if (this.textMap == null) {
                    return;
                }
                this.previewDisplayTC = (TextControl)this.textMap.getControl();
                if (this.previewDisplayTC != null) {
                    double size;
                    double val;
                    String str = this.scaleTextField.getText();
                    try {
                        val = Double.valueOf(str);
                        if (val <= 0.0) {
                            val = 1.0;
                            this.scaleTextField.setText("1.0");
                        }
                    }
                    catch (NumberFormatException e) {
                        val = 1.0;
                        this.scaleTextField.setText("1.0");
                    }
                    this.previewDisplayTC.setScale(val);
                    this.textControl.setScale(val);
                    String justStr = (String)this.horizJustificationJComboBox.getSelectedItem();
                    if (justStr.equals("Left")) {
                        this.previewDisplayTC.setJustification(TextControl.Justification.LEFT);
                        this.textControl.setJustification(TextControl.Justification.LEFT);
                    } else if (justStr.equals("Right")) {
                        this.previewDisplayTC.setJustification(TextControl.Justification.RIGHT);
                        this.textControl.setJustification(TextControl.Justification.RIGHT);
                    } else {
                        this.previewDisplayTC.setJustification(TextControl.Justification.CENTER);
                        this.textControl.setJustification(TextControl.Justification.CENTER);
                    }
                    justStr = (String)this.vertJustificationJComboBox.getSelectedItem();
                    if (justStr.equals("Bottom")) {
                        this.previewDisplayTC.setVerticalJustification(TextControl.Justification.BOTTOM);
                        this.textControl.setVerticalJustification(TextControl.Justification.BOTTOM);
                    } else if (justStr.equals("Top")) {
                        this.previewDisplayTC.setVerticalJustification(TextControl.Justification.TOP);
                        this.textControl.setVerticalJustification(TextControl.Justification.TOP);
                    } else {
                        this.previewDisplayTC.setVerticalJustification(TextControl.Justification.CENTER);
                        this.textControl.setVerticalJustification(TextControl.Justification.CENTER);
                    }
                    this.previewDisplayTC.setFont(this.getSelectedFont());
                    this.textControl.setFont(this.getSelectedFont());
                    try {
                        size = Integer.parseInt((String)this.fontSizesJList.getSelectedValue());
                    }
                    catch (Exception e) {
                        size = 12.0;
                    }
                    this.previewDisplayTC.setSize(size / 12.0);
                    this.textControl.setSize(size / 12.0);
                    str = this.textOrientationField.getText();
                    try {
                        val = Double.valueOf(str);
                    }
                    catch (NumberFormatException e) {
                        val = 0.0;
                        this.textOrientationField.setText("0.0");
                    }
                    this.previewDisplayTC.setRotation(val);
                    this.textControl.setRotation(val);
                    str = this.characterRotationField.getText();
                    try {
                        val = Double.valueOf(str);
                    }
                    catch (NumberFormatException e) {
                        val = 0.0;
                        this.characterRotationField.setText("0.0");
                    }
                    this.previewDisplayTC.setCharacterRotation(val);
                    this.textControl.setCharacterRotation(val);
                    double offsetX = 0.0;
                    str = this.offsetXField.getText();
                    try {
                        offsetX = Double.valueOf(str);
                    }
                    catch (NumberFormatException e) {
                        this.offsetXField.setText("0.0");
                    }
                    double offsetY = 0.0;
                    str = this.offsetYField.getText();
                    try {
                        offsetY = Double.valueOf(str);
                    }
                    catch (NumberFormatException e) {
                        this.offsetYField.setText("0.0");
                    }
                    double offsetZ = 0.0;
                    str = this.offsetZField.getText();
                    try {
                        offsetZ = Double.valueOf(str);
                    }
                    catch (NumberFormatException e) {
                        this.offsetZField.setText("0.0");
                    }
                    double[] offsets = new double[]{offsetX, offsetY, offsetZ};
                    this.previewDisplayTC.setOffset(offsets);
                    this.textControl.setOffset(offsets);
                    this.previewDisplayTC.setAutoSize(this.autoSizeJCheckBox.isSelected());
                    this.textControl.setAutoSize(this.autoSizeJCheckBox.isSelected());
                    break block28;
                }
                System.out.println("TextControl is null?");
            }
            catch (RemoteException e) {
                System.out.println("Exception: " + e);
            }
            catch (VisADException e1) {
                System.out.println("Exception: " + e1);
            }
        }
    }
}

