/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlType;

class SqlInputValue {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Case caseConversion;
    private Object inputValue;
    private String likeChar;
    private int minLikeLength;
    private SqlType type;

    SqlInputValue(Object inputValue, Case caseConversion, SqlType type) {
        this.inputValue = inputValue;
        this.caseConversion = caseConversion;
        this.type = type;
    }

    void setQueryParam(SQLQuery query, String paramName) {
        Object o = this.inputValue;
        if (this.inputValue instanceof String) {
            if (this.caseConversion == Case.NONE) {
                o = this.processLike(this.inputValue);
            } else if (this.caseConversion == Case.LOWER) {
                o = this.inputValue != null ? this.processLike(this.inputValue).toLowerCase() : (String)null;
            } else if (this.caseConversion == Case.UPPER) {
                o = this.inputValue != null ? this.processLike(this.inputValue).toUpperCase() : (String)null;
            }
        }
        this.type.setParameter((Query)query, paramName, o);
    }

    void setLike(String likeChar, Integer minLikeLength) {
        this.likeChar = likeChar;
        this.minLikeLength = minLikeLength == null ? 1 : minLikeLength;
    }

    private String processLike(Object val) {
        String param = (String)val;
        if (this.likeChar != null && param != null) {
            param = param.trim();
            int length = param.length();
            boolean startsWith = param.startsWith(this.likeChar);
            boolean endsWith = param.endsWith(this.likeChar);
            if (startsWith && endsWith) {
                return param;
            }
            if (startsWith) {
                if (length >= this.minLikeLength + 1) {
                    return param + this.likeChar;
                }
                return param;
            }
            if (endsWith) {
                if (length >= this.minLikeLength + 1) {
                    return this.likeChar + param;
                }
                return param;
            }
            if (length >= this.minLikeLength) {
                return this.likeChar + param + this.likeChar;
            }
            return param;
        }
        return param;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlInputValue:");
        sb.append(" caseConversion=").append((Object)this.caseConversion);
        sb.append(" value='").append(this.inputValue).append("'");
        return sb.toString();
    }

    static enum Case {
        NONE,
        UPPER,
        LOWER;

    }
}

