/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaIdent;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlMetaText;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;

class SqlMetaAndOrItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<SqlMetaSimple> elements = new ArrayList<SqlMetaSimple>();

    SqlMetaAndOrItem() {
    }

    void addElement(SqlMetaSimple element) {
        this.elements.add(element);
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        result.addTrue();
        StringBuilder s = new StringBuilder();
        result.setSql(s);
        boolean like = false;
        for (SqlMetaSimple item : this.elements) {
            SqlProcessResult itemResult = item.process(ctx);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DataAndItem process " + item.getClass() + " " + item + " " + itemResult);
            }
            if (itemResult.isAdd()) {
                s.append((CharSequence)itemResult.getSql());
                result.addInputValues(itemResult.getInputValues());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("DataAndItem process, add " + itemResult.getSql() + " " + itemResult.getInputValues());
                }
                if (ctx.isFeature("SURROUND_QUERY_LIKE") && item instanceof SqlMetaIdent && like) {
                    for (String ident : itemResult.getInputValues().keySet()) {
                        itemResult.getInputValues().get(ident).setLike(ctx.getFeature("WILDCARD_CHARACTER"), ctx.getFeatureAsInt("SURROUND_QUERY_MIN_LEN"));
                    }
                    continue;
                }
                if (item instanceof SqlMetaText && ctx.isFeature("SURROUND_QUERY_LIKE") && itemResult.getSql().toString().trim().toLowerCase().endsWith(ctx.getFeature("LIKE_STRING"))) {
                    like = true;
                    continue;
                }
                like = false;
                continue;
            }
            result.addFalse();
        }
        return result;
    }
}

