/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.sqlproc.engine.impl.SqlInputValue;

public class SqlProcessResult
implements Comparable<SqlProcessResult> {
    private boolean add;
    private Map<String, SqlInputValue> inputValues;
    private StringBuilder sql;
    private Integer orderIndex;

    SqlProcessResult() {
        this.inputValues = new HashMap<String, SqlInputValue>();
        this.sql = new StringBuilder();
    }

    SqlProcessResult(String sql) {
        this.inputValues = null;
        if (sql != null) {
            this.sql = new StringBuilder(sql);
            this.add = true;
        } else {
            this.sql = null;
            this.add = false;
        }
    }

    void addFalse() {
        this.add = false;
    }

    void addTrue() {
        this.add = true;
    }

    void add(boolean add) {
        this.add = add;
    }

    boolean isAdd() {
        return this.add;
    }

    void addInputValue(String key, SqlInputValue value) {
        if (!this.inputValues.containsKey(key)) {
            this.inputValues.put(key, value);
        }
    }

    void addInputValues(Map<String, SqlInputValue> inputValues) {
        if (inputValues != null) {
            this.inputValues.putAll(inputValues);
        }
    }

    Map<String, SqlInputValue> getInputValues() {
        return this.inputValues;
    }

    void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    public void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }

    public Integer getOrderIndex() {
        return this.orderIndex;
    }

    public void setQueryParams(SQLQuery query) {
        for (String paramName : this.inputValues.keySet()) {
            SqlInputValue inputValue = this.inputValues.get(paramName);
            inputValue.setQueryParam(query, paramName);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlProcessResult:");
        sb.append(" add=").append(this.add);
        if (this.inputValues != null) {
            for (String paramName : this.inputValues.keySet()) {
                SqlInputValue value = this.inputValues.get(paramName);
                sb.append(", ident=").append(paramName).append(", value=").append(value);
            }
        }
        sb.append(" s='").append((CharSequence)this.sql).append("'");
        return sb.toString();
    }

    @Override
    public int compareTo(SqlProcessResult o) {
        if (this.getOrderIndex() == null || o.getOrderIndex() == null) {
            throw new RuntimeException("Compared non-order processing results");
        }
        return this.getOrderIndex().compareTo(o.getOrderIndex());
    }
}

