/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaType;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMappingItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> javaNames = new ArrayList<String>();
    private String dbName;
    private SqlType sqlType = new SqlType();

    SqlMappingItem(String dbName) {
        this.dbName = dbName;
    }

    String getDbName() {
        return this.dbName;
    }

    void addName(String name) {
        this.javaNames.add(name);
    }

    List<String> getJavaNames() {
        return this.javaNames;
    }

    void setJavaNames(List<String> javaNames) {
        this.javaNames = javaNames;
    }

    void setMetaType(String sMetaType) {
        this.sqlType = sMetaType.startsWith("h_") ? new SqlType(sMetaType.substring(2)) : new SqlType(sMetaType, this.sqlType);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    void setHibernateType(String sHibernateType) {
        this.sqlType = new SqlType(sHibernateType);
    }

    void setValue(String value) {
        this.sqlType.setValue(value);
    }

    public void setQueryResultMapping(Class<?> resultClass, SQLQuery query) {
        Type hibernateType = null;
        if (this.sqlType.getMetaType() != SqlMetaType.DEFAULT) {
            hibernateType = this.sqlType.getHibernateType();
        } else {
            int count = this.javaNames.size();
            boolean exit = false;
            Class<?> objClass = resultClass;
            for (int i = 0; i < count - 1 && !exit; ++i) {
                String name = this.javaNames.get(i);
                Method m = SqlUtils.getMethod(objClass, SqlUtils.get(name), SqlUtils.is(name));
                if (m != null) {
                    objClass = m.getReturnType();
                    continue;
                }
                exit = true;
            }
            if (!exit) {
                String name = count > 0 ? this.javaNames.get(count - 1) : this.dbName;
                hibernateType = this.sqlType.getHibernateType(objClass, name);
            }
        }
        if (hibernateType != null) {
            query.addScalar(this.dbName, hibernateType);
        } else {
            query.addScalar(this.dbName);
        }
    }

    void setQueryResultData(Object resultInstance, Object resultValue) {
        if (resultValue == null) {
            return;
        }
        int count = this.javaNames.size();
        boolean exit = false;
        Object obj = resultInstance;
        for (int i = 0; i < count - 1 && !exit; ++i) {
            String name = this.javaNames.get(i);
            Method m = SqlUtils.getMethod(obj.getClass(), SqlUtils.get(name), SqlUtils.is(name));
            if (m != null) {
                Object nextObj = SqlUtils.invokeMethod(m, obj);
                if (nextObj == null) {
                    nextObj = SqlUtils.getInstance(m.getReturnType());
                    if (nextObj != null) {
                        m = SqlUtils.getMethod(obj.getClass(), SqlUtils.set(name), nextObj.getClass());
                        SqlUtils.invokeMethod(m, obj, nextObj);
                    } else {
                        exit = true;
                    }
                }
                obj = nextObj;
                continue;
            }
            exit = true;
        }
        if (!exit) {
            String name = count > 0 ? this.javaNames.get(count - 1) : this.dbName;
            this.sqlType.setResult(obj, name, resultValue);
        }
    }

    SqlMappingItem merge(SqlMappingItem outputMapping) {
        SqlMappingItem resultMappingItem = new SqlMappingItem(this.dbName);
        if (this.javaNames != null && this.javaNames.size() > 0) {
            resultMappingItem.setJavaNames(this.javaNames);
        } else {
            resultMappingItem.setJavaNames(outputMapping.getJavaNames());
        }
        if (this.sqlType != null) {
            resultMappingItem.setSqlType(this.sqlType);
        } else {
            resultMappingItem.setSqlType(outputMapping.getSqlType());
        }
        return resultMappingItem;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(this.dbName);
        result.addOutputValue(this.dbName, this);
        return result;
    }

    public String toString() {
        return "SqlMappingItem [logger=" + this.logger + ", javaNames=" + this.javaNames + ", dbName=" + this.dbName + ", sqlType=" + this.sqlType + "]";
    }
}

