package org.sqlproc.engine.impl.type;

import org.hibernate.Hibernate;
import org.hibernate.type.Type;

/**
 * The SQL META Types for BOOLEAN.
 * 
 * @author <a href="mailto:Vladimir.Hudec@gmail.com">Vladimir Hudec</a>
 */
public class SqlBooleanType extends SqlGenericType {

    /**
     * {@inheritDoc}
     */
    @Override
    public Type getHibernateType() {
        return Hibernate.BOOLEAN;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[] { Boolean.class, boolean.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String[] getMetaTypes() {
        return new String[] { "BOOLEAN", "BOOL" };
    }
}
