/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.type.SqlBigDecimalType;
import org.sqlproc.engine.impl.type.SqlBigIntegerType;
import org.sqlproc.engine.impl.type.SqlBooleanType;
import org.sqlproc.engine.impl.type.SqlByteArrayType;
import org.sqlproc.engine.impl.type.SqlByteType;
import org.sqlproc.engine.impl.type.SqlCharType;
import org.sqlproc.engine.impl.type.SqlDateTimeType;
import org.sqlproc.engine.impl.type.SqlDateType;
import org.sqlproc.engine.impl.type.SqlDefaultType;
import org.sqlproc.engine.impl.type.SqlDoubleType;
import org.sqlproc.engine.impl.type.SqlEnumIntegerType;
import org.sqlproc.engine.impl.type.SqlEnumStringType;
import org.sqlproc.engine.impl.type.SqlFloatType;
import org.sqlproc.engine.impl.type.SqlFromDateType;
import org.sqlproc.engine.impl.type.SqlGenericType;
import org.sqlproc.engine.impl.type.SqlIntegerType;
import org.sqlproc.engine.impl.type.SqlLongType;
import org.sqlproc.engine.impl.type.SqlShortType;
import org.sqlproc.engine.impl.type.SqlStringType;
import org.sqlproc.engine.impl.type.SqlTimeType;
import org.sqlproc.engine.impl.type.SqlTimestampType;
import org.sqlproc.engine.impl.type.SqlToDateType;

public abstract class SqlMetaType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final SqlMetaType DEFAULT = new SqlDefaultType();
    public static final SqlMetaType ENUM_INT = new SqlEnumIntegerType();
    public static final SqlMetaType ENUM_STRING = new SqlEnumStringType();
    public static final SqlMetaType[] TYPES = new SqlMetaType[]{new SqlBigDecimalType(), new SqlBigIntegerType(), new SqlBooleanType(), new SqlByteArrayType(), new SqlByteType(), new SqlCharType(), new SqlDateTimeType(), new SqlDateType(), new SqlDoubleType(), ENUM_INT, ENUM_STRING, new SqlFloatType(), new SqlFromDateType(), new SqlIntegerType(), new SqlLongType(), new SqlShortType(), new SqlStringType(), new SqlTimestampType(), new SqlTimeType(), new SqlToDateType()};
    public static Map<Class<?>, SqlMetaType> CLASS_TO_TYPE_MAP = new HashMap();
    public static Map<String, SqlMetaType> META_TO_TYPE_MAP = new HashMap<String, SqlMetaType>();

    public abstract void setResult(Object var1, String var2, Object var3, boolean var4) throws SqlRuntimeException;

    public abstract void setParameter(Query var1, String var2, Object var3, Class<?> var4, boolean var5) throws SqlRuntimeException;

    static {
        for (SqlMetaType type : TYPES) {
            if (!(type instanceof SqlGenericType)) continue;
            for (Class<?> classType : ((SqlGenericType)type).getClassTypes()) {
                CLASS_TO_TYPE_MAP.put(classType, type);
            }
            for (String metaType : ((SqlGenericType)type).getMetaTypes()) {
                META_TO_TYPE_MAP.put(metaType.toUpperCase(), type);
            }
        }
        CLASS_TO_TYPE_MAP = Collections.unmodifiableMap(CLASS_TO_TYPE_MAP);
        META_TO_TYPE_MAP = Collections.unmodifiableMap(META_TO_TYPE_MAP);
    }
}

