/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.impl.SqlEmptyMonitor;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SimpleSqlPluginFactory;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidator;

public abstract class SqlEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String name;
    protected SqlMetaStatement statement;
    protected SqlMappingRule mapping;
    protected Map<String, Object> features = new HashMap<String, Object>();
    protected SqlMonitor monitor;
    protected SqlValidator validator;
    protected SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;

    public SqlEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        this.name = name;
        this.statement = statement;
        this.mapping = mapping;
        if (features != null) {
            for (Map.Entry<String, Object> feature : features.entrySet()) {
                this.setFeature(feature.getKey(), feature.getValue());
            }
        }
        this.monitor = monitor != null ? monitor : new SqlEmptyMonitor();
        this.typeFactory = typeFactory;
        this.pluginFactory = pluginFactory != null ? pluginFactory : SimpleSqlPluginFactory.getInstance();
    }

    public void setValidator(SqlValidator validator) {
        this.validator = validator;
    }

    public void setFeature(String name, Object value) {
        this.features.put(name, value);
        this.unsetFeatures(SqlUtils.oppositeFeatures(name));
    }

    public void unsetFeatures(Set<String> names) {
        if (names != null) {
            for (String name : names) {
                this.features.remove(name);
            }
        }
    }

    Object getStaticInputValues(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getStaticInputValues();
    }

    int getMaxTimeout(SqlControl sqlControl) {
        if (sqlControl == null) {
            return 0;
        }
        return sqlControl.getMaxTimeout();
    }

    int getFirstResult(SqlControl sqlControl) {
        if (sqlControl == null) {
            return 0;
        }
        return sqlControl.getFirstResult();
    }

    int getMaxResults(SqlControl sqlControl) {
        if (sqlControl == null) {
            return 0;
        }
        return sqlControl.getMaxResults();
    }

    SqlOrder getOrder(SqlControl sqlControl) {
        if (sqlControl == null || sqlControl.getOrder() == null) {
            return SqlQueryEngine.NO_ORDER;
        }
        return sqlControl.getOrder();
    }

    Map<String, Class<?>> getMoreResultClasses(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getMoreResultClasses();
    }

    Map<String, Object> getFeatures(SqlControl sqlControl) {
        if (sqlControl == null) {
            return null;
        }
        return sqlControl.getFeatures();
    }

    void checkDynamicInputValues(Object dynamicInputValues) {
        if (dynamicInputValues == null) {
            return;
        }
        if (dynamicInputValues instanceof SqlOrder) {
            throw new InvalidParameterException("SqlOrder used as dynamic input values");
        }
        if (dynamicInputValues instanceof SqlControl) {
            throw new InvalidParameterException("SqlControl used as dynamic input values");
        }
    }

    void checkStaticInputValues(Object staticInputValues) {
        if (staticInputValues == null) {
            return;
        }
        if (staticInputValues instanceof SqlOrder) {
            throw new InvalidParameterException("SqlOrder used as static input values");
        }
        if (staticInputValues instanceof SqlControl) {
            throw new InvalidParameterException("SqlControl used as static input values");
        }
    }
}

