/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.jdbc.JdbcQuery;

public class JdbcSession
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Connection.class, SqlSession.class};
    private final Connection connection;
    private String name;

    private JdbcSession(Connection connection) {
        this.connection = connection;
    }

    public JdbcSession(Connection connection, String name) {
        this(connection);
        this.name = name;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            this.connection.close();
            return null;
        }
        if ("createSqlQuery".equals(method.getName())) {
            String queryString = (String)args[0];
            return new JdbcQuery(this.connection, queryString);
        }
        if ("executeBatch".equals(method.getName())) {
            String[] statements = (String[])args[0];
            JdbcQuery jdbcQuery = new JdbcQuery(this.connection, null);
            return jdbcQuery.executeBatch(statements);
        }
        if ("getName".equals(method.getName())) {
            return this.name;
        }
        try {
            return method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static SqlSession generateProxy(Connection connection) {
        JdbcSession handler = new JdbcSession(connection);
        return (SqlSession)Proxy.newProxyInstance(JdbcSession.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)handler);
    }

    public static SqlSession generateProxy(Connection connection, String name) {
        JdbcSession handler = new JdbcSession(connection, name);
        return (SqlSession)Proxy.newProxyInstance(JdbcSession.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)handler);
    }

    public static ClassLoader getProxyClassLoader() {
        return SqlSession.class.getClassLoader();
    }
}

