/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlFilesLoader;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlProcessorLoader;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.config.SqlEngineConfiguration;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlDefaultFactory
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LINESEP = System.getProperty("line.separator");
    private List<String> metaFilesNames = new ArrayList<String>();
    private StringBuilder metaStatements;
    private SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;
    private String filter;
    private SqlMonitorFactory monitorFactory;
    private List<SqlInternalType> customTypes;
    private String[] onlyStatements;
    private boolean jdbc;
    private volatile SqlProcessorLoader processorLoader;
    private SqlValidatorFactory validatorFactory;
    private Boolean lazyInit;
    private Integer asyncInitThreads;
    private SqlEngineConfiguration configuration;
    private Executor executor;
    private Boolean executorTerminated;

    public SqlDefaultFactory() {
    }

    public SqlDefaultFactory(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public SqlDefaultFactory(int asyncInitThreads) {
        this.asyncInitThreads = asyncInitThreads;
    }

    public SqlDefaultFactory(boolean lazyInit, int asyncInitThreads) {
        this.lazyInit = lazyInit;
        this.asyncInitThreads = asyncInitThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.processorLoader == null) {
            SqlDefaultFactory sqlDefaultFactory = this;
            synchronized (sqlDefaultFactory) {
                if (this.processorLoader == null) {
                    Executor _executor;
                    if (this.configuration == null) {
                        this.setConfiguration(new SqlEngineConfiguration());
                    }
                    if (this.metaStatements == null && (this.metaFilesNames == null || this.metaFilesNames.isEmpty())) {
                        throw new SqlProcessorException("There are no META SQL statements");
                    }
                    if (this.metaStatements == null) {
                        this.metaStatements = SqlFilesLoader.getStatements(this.getClass(), this.metaFilesNames.toArray(new String[0]));
                    }
                    if (this.jdbc) {
                        this.metaStatements.append(LINESEP).append("JDBC(BOPT)=true;");
                    }
                    SqlProcessorLoader loader = new SqlProcessorLoader(this.metaStatements, this.typeFactory, this.pluginFactory, this.filter, this.monitorFactory, this.validatorFactory, this.customTypes, this.configuration, this.onlyStatements);
                    if (this.configuration != null) {
                        for (Map.Entry<String, String> e : this.configuration.getDynamicQueryEngines().entrySet()) {
                            loader.getDynamicEngine(e.getKey(), SqlProcessorLoader.EngineType.Query, e.getValue());
                            this.logger.warn("== init, initialized dynamic Query Engine {}", (Object)e.getKey());
                        }
                        for (Map.Entry<String, String> e : this.configuration.getDynamicCrudEngines().entrySet()) {
                            loader.getDynamicEngine(e.getKey(), SqlProcessorLoader.EngineType.Crud, e.getValue());
                            this.logger.warn("== init, initialized dynamic CRUD Engine {}", (Object)e.getKey());
                        }
                        for (Map.Entry<String, String> e : this.configuration.getDynamicProcedureEngines().entrySet()) {
                            loader.getDynamicEngine(e.getKey(), SqlProcessorLoader.EngineType.Procedure, e.getValue());
                            this.logger.warn("== init, initialized dynamic Procedure Engine {}", (Object)e.getKey());
                        }
                    }
                    if (!this.isLazyInit()) {
                        _executor = this.getExecutor();
                        loader.init(_executor, null, null, null);
                        if (_executor != null && _executor instanceof ExecutorService) {
                            ((ExecutorService)_executor).shutdown();
                        }
                    }
                    if (this.isLazyInit() && this.configuration != null) {
                        _executor = this.getExecutor();
                        loader.init(_executor, this.configuration.getQueryEnginesToInit(this.configuration.getInitTreshold()).keySet(), this.configuration.getCrudEnginesToInit(this.configuration.getInitTreshold()).keySet(), this.configuration.getProcedureEnginesToInit(this.configuration.getInitTreshold()).keySet());
                        if (_executor != null && _executor instanceof ExecutorService) {
                            ((ExecutorService)_executor).shutdown();
                        }
                    }
                    if (this.configuration != null && this.configuration.getInitClearUsage() != null && this.configuration.getInitClearUsage().booleanValue()) {
                        this.configuration.clearUsage();
                    }
                    this.processorLoader = loader;
                }
            }
        }
    }

    public void init0() {
        if (this.getLoader() == null) {
            this.init();
        }
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Query);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addQueryEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Crud);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addCrudEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getEngine(name, SqlProcessorLoader.EngineType.Procedure);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addProcedureEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getStaticQueryEngine(String name) {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Query);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addQueryEngine(name);
            this.configuration.removeDynamicQueryEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getStaticCrudEngine(String name) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Crud);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addCrudEngine(name);
            this.configuration.removeDynamicCrudEngine(name);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getStaticProcedureEngine(String name) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getStaticEngine(name, SqlProcessorLoader.EngineType.Procedure);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addProcedureEngine(name);
            this.configuration.removeDynamicProcedureEngine(name);
        }
        return sqlEngine;
    }

    private void check(String name, SqlEngine sqlEngine) {
        if (sqlEngine == null) {
            throw new SqlEngineException("Missing SqlEngine " + name);
        }
    }

    @Override
    public SqlQueryEngine getCheckedQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getCheckedStaticQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getStaticQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedStaticCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getStaticCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedStaticProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getStaticProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getDynamicQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        this.init0();
        SqlQueryEngine sqlEngine = (SqlQueryEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Query, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicQueryEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getDynamicCrudEngine(String name, String sqlStatement) {
        this.init0();
        SqlCrudEngine sqlEngine = (SqlCrudEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Crud, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicCrudEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getDynamicProcedureEngine(String name, String sqlStatement) {
        this.init0();
        SqlProcedureEngine sqlEngine = (SqlProcedureEngine)this.getLoader().getDynamicEngine(name, SqlProcessorLoader.EngineType.Procedure, sqlStatement);
        if (sqlEngine != null && this.configuration != null) {
            this.configuration.addDynamicProcedureEngine(name, sqlStatement);
        }
        return sqlEngine;
    }

    public List<String> getMetaFilesNames() {
        return this.metaFilesNames;
    }

    public void setMetaFilesNames(List<String> metaFilesNames) {
        this.metaFilesNames = metaFilesNames;
    }

    public void setMetaFilesNames(String ... metaFilesNames) {
        this.metaFilesNames = new ArrayList<String>();
        Collections.addAll(this.metaFilesNames, metaFilesNames);
    }

    public StringBuilder getMetaStatements() {
        return this.metaStatements;
    }

    public void setMetaStatements(StringBuilder metaStatements) {
        this.metaStatements = metaStatements;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(SqlTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public SqlPluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public void setPluginFactory(SqlPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setFilter(SqlFeature filter) {
        this.filter = filter.name();
    }

    public SqlMonitorFactory getMonitorFactory() {
        return this.monitorFactory;
    }

    public void setMonitorFactory(SqlMonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public List<SqlInternalType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(List<SqlInternalType> customTypes) {
        this.customTypes = customTypes;
    }

    public void setCustomTypes(SqlInternalType ... customTypes) {
        this.customTypes = new ArrayList<SqlInternalType>();
        Collections.addAll(this.customTypes, customTypes);
    }

    public void addCustomType(SqlInternalType customType) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList<SqlInternalType>();
        }
        this.customTypes.add(customType);
    }

    public String[] getOnlyStatements() {
        return this.onlyStatements;
    }

    public void setOnlyStatements(String[] selectQueries) {
        this.onlyStatements = selectQueries != null ? Arrays.copyOf(selectQueries, selectQueries.length) : null;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    @Override
    public boolean isLazyInit() {
        return this.configuration != null && this.configuration.getLazyInit() != null && this.configuration.getLazyInit() != false;
    }

    public void setLazyInit(Boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @Override
    public int getAsyncInitThreads() {
        if (this.configuration != null && this.configuration.getAsyncInitThreads() != null) {
            return this.configuration.getAsyncInitThreads();
        }
        return 0;
    }

    public void setAsyncInitThreads(Integer asyncInitThreads) {
        this.asyncInitThreads = asyncInitThreads;
    }

    @Override
    public Boolean isAsyncInitFinished() {
        return this.executorTerminated;
    }

    public SqlProcessorLoader getLoader() {
        return this.processorLoader;
    }

    public SqlValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(SqlValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public Collection<String> getQueryNames() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Query).keySet();
    }

    @Override
    public Collection<String> getQueryDynamicNames() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Query).keySet();
    }

    @Override
    public Map<String, SqlEngine> getQueryEngines() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Query);
    }

    @Override
    public Map<String, SqlEngine> getQueryDynamicEngines() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Query);
    }

    @Override
    public Collection<String> getCrudNames() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Crud).keySet();
    }

    @Override
    public Collection<String> getCrudDynamicNames() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Crud).keySet();
    }

    @Override
    public Map<String, SqlEngine> getCrudEngines() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Crud);
    }

    @Override
    public Map<String, SqlEngine> getCrudDynamicEngines() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Crud);
    }

    @Override
    public Collection<String> getProcedureNames() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Procedure).keySet();
    }

    @Override
    public Collection<String> getProcedureDynamicNames() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Procedure).keySet();
    }

    @Override
    public Map<String, SqlEngine> getProcedureEngines() {
        return this.getLoader().getEngines(SqlProcessorLoader.EngineType.Procedure);
    }

    @Override
    public Map<String, SqlEngine> getProcedureDynamicEngines() {
        return this.getLoader().getDynamicEngines(SqlProcessorLoader.EngineType.Procedure);
    }

    @Override
    public Map<String, String> getEnginesInitErrors() {
        return this.getLoader().getEnginesInitErrors();
    }

    @Override
    public String getEnginesInitErrorsMsg() {
        return this.getLoader().getEnginesInitErrorsMsg();
    }

    @Override
    public SqlEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SqlEngineConfiguration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            if (configuration.getLazyInit() == null) {
                configuration.setLazyInit(this.lazyInit);
            }
            if (configuration.getAsyncInitThreads() == null) {
                configuration.setAsyncInitThreads(this.asyncInitThreads);
            }
        }
        if (this.processorLoader != null) {
            this.processorLoader.setConfiguration(configuration);
        }
    }

    protected Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.getAsyncInitThreads() > 0) {
            return new SqlThreadPoolExecutor(this.getAsyncInitThreads(), this);
        }
        return null;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public static class SqlThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        protected SqlDefaultFactory factory;

        public SqlThreadPoolExecutor(int corePoolSize, SqlDefaultFactory factory) {
            super(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.factory = factory;
            if (factory != null) {
                factory.executorTerminated = false;
            }
        }

        @Override
        public void shutdown() {
            this.logger.warn("== shutdown: executed tasks: {}", (Object)this.getCompletedTaskCount());
            this.logger.warn("== shutdown: running tasks: {}", (Object)this.getActiveCount());
            this.logger.warn("== shutdown: pending tasks:, {}", (Object)this.getQueue().size());
            super.shutdown();
        }

        @Override
        protected void terminated() {
            this.logger.warn("== terminated");
            super.terminated();
            if (this.factory != null) {
                this.factory.executorTerminated = true;
            }
        }
    }
}

