/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.validation.SqlValidationContext;
import org.sqlproc.engine.validation.SqlValidationException;
import org.sqlproc.engine.validation.SqlValidationResult;
import org.sqlproc.engine.validation.SqlValidator;

public class SqlProcessResult
implements Comparable<SqlProcessResult> {
    private SqlProcessContext ctx;
    private boolean add;
    private List<String> allInputValues;
    private Map<String, SqlInputValue> inputValues;
    private Map<String, SqlMappingItem> outputValues;
    private Map<String, SqlInputValue> identities;
    private Map<String, SqlInputValue> outValues;
    private StringBuilder sql;
    private Integer orderIndex;
    private boolean skipNextText;
    boolean logError;

    SqlProcessResult(SqlProcessContext ctx) {
        this.ctx = ctx;
        this.allInputValues = new ArrayList<String>();
        this.inputValues = new LinkedHashMap<String, SqlInputValue>();
        this.outputValues = new LinkedHashMap<String, SqlMappingItem>();
        this.identities = new HashMap<String, SqlInputValue>();
        this.outValues = new HashMap<String, SqlInputValue>();
        this.sql = new StringBuilder();
    }

    SqlProcessResult(SqlProcessContext ctx, String sql) {
        this.ctx = ctx;
        this.allInputValues = new ArrayList<String>();
        this.inputValues = new LinkedHashMap<String, SqlInputValue>();
        this.outputValues = new LinkedHashMap<String, SqlMappingItem>();
        this.identities = new HashMap<String, SqlInputValue>();
        this.outValues = new HashMap<String, SqlInputValue>();
        if (sql != null) {
            this.sql = new StringBuilder(sql);
            this.add = true;
        } else {
            this.sql = null;
            this.add = false;
        }
    }

    public SqlProcessResult(SqlProcessResult result, Object dynamicInputValues, SqlControl sqlControl) {
        this.ctx = new SqlProcessContext(result.ctx, dynamicInputValues, sqlControl);
        this.add = result.add;
        this.allInputValues = result.allInputValues;
        if (result.inputValues != null) {
            this.inputValues = new LinkedHashMap<String, SqlInputValue>();
            for (Map.Entry<String, SqlInputValue> e : result.inputValues.entrySet()) {
                this.inputValues.put(e.getKey(), new SqlInputValue(this.ctx, e.getKey(), e.getValue(), dynamicInputValues));
            }
        }
        this.outputValues = result.outputValues;
        if (result.identities != null) {
            this.identities = new HashMap<String, SqlInputValue>();
            for (Map.Entry<String, SqlInputValue> e : result.identities.entrySet()) {
                this.identities.put(e.getKey(), this.inputValues.get(e.getKey()));
            }
        }
        if (result.outValues != null) {
            this.outValues = new HashMap<String, SqlInputValue>();
            for (Map.Entry<String, SqlInputValue> e : result.outValues.entrySet()) {
                this.outValues.put(e.getKey(), this.inputValues.get(e.getKey()));
            }
        }
        this.sql = result.sql;
        this.orderIndex = result.orderIndex;
        this.skipNextText = result.skipNextText;
        this.logError = result.logError;
    }

    SqlProcessContext getCtx() {
        return this.ctx;
    }

    public SqlRuntimeContext getRuntimeContext() {
        return this.ctx;
    }

    void addFalse() {
        this.add = false;
    }

    void addTrue() {
        this.add = true;
    }

    void add(boolean add) {
        this.add = add;
    }

    boolean isAdd() {
        return this.add;
    }

    void addInputValue(String key, SqlInputValue value) {
        this.allInputValues.add(key);
        if (!this.inputValues.containsKey(key)) {
            this.inputValues.put(key, value);
        }
    }

    void addInputValues(List<String> inputValues) {
        if (inputValues != null) {
            this.allInputValues.addAll(inputValues);
        }
    }

    void addMappedInputValues(Map<String, SqlInputValue> inputValues) {
        if (inputValues != null) {
            this.inputValues.putAll(inputValues);
        }
    }

    List<String> getInputValues() {
        return this.allInputValues;
    }

    Map<String, SqlInputValue> getMappedInputValues() {
        return this.inputValues;
    }

    SqlInputValue getInputValue(String name) {
        return this.inputValues.get(name);
    }

    void addOutputValue(String key, SqlMappingItem value) {
        if (!this.outputValues.containsKey(key)) {
            this.outputValues.put(key, value);
        }
    }

    void addOutputValues(Map<String, SqlMappingItem> outputValues) {
        if (outputValues != null) {
            this.outputValues.putAll(outputValues);
        }
    }

    Map<String, SqlMappingItem> getOutputValues() {
        return this.outputValues;
    }

    void addIdentity(String key, SqlInputValue value) {
        if (!this.identities.containsKey(key)) {
            this.identities.put(key, value);
        }
    }

    void addIdentities(Map<String, SqlInputValue> identities) {
        if (identities != null) {
            this.identities.putAll(identities);
        }
    }

    public Map<String, SqlInputValue> getIdentities() {
        return this.identities;
    }

    void addOutValue(String key, SqlInputValue value) {
        if (!this.outValues.containsKey(key)) {
            this.outValues.put(key, value);
        }
    }

    void addOutValues(Map<String, SqlInputValue> outValues) {
        if (outValues != null) {
            this.outValues.putAll(outValues);
        }
    }

    Map<String, SqlInputValue> getOutValues() {
        return this.outValues;
    }

    void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }

    Integer getOrderIndex() {
        return this.orderIndex;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public boolean isLogError() {
        return this.logError;
    }

    boolean isSkipNextText() {
        return this.skipNextText;
    }

    void setSkipNextText(boolean skipNextText) {
        this.skipNextText = skipNextText;
    }

    public boolean setQueryParams(SqlSession session, SqlQuery query) throws SqlRuntimeException {
        int numNotEmptyParamsInSetOrUpdate = 0;
        for (String paramName : this.allInputValues) {
            SqlInputValue inputValue = this.inputValues.get(paramName);
            if (inputValue.getInputValue() != null && inputValue.getInSetOrInsert() != null && inputValue.getInSetOrInsert().booleanValue()) {
                ++numNotEmptyParamsInSetOrUpdate;
            }
            inputValue.setQueryParam(this.getRuntimeContext().getTypeFactory(), session, query, paramName);
        }
        return numNotEmptyParamsInSetOrUpdate > 0;
    }

    public void postProcess() throws SqlRuntimeException {
        SqlInputValue inputValue;
        for (String paramName : this.identities.keySet()) {
            inputValue = this.identities.get(paramName);
            inputValue.setIdentityResult(paramName);
        }
        for (String paramName : this.outValues.keySet()) {
            inputValue = this.outValues.get(paramName);
            inputValue.setOutValueResult(paramName);
        }
    }

    @Override
    public int compareTo(SqlProcessResult o) {
        if (this.getOrderIndex() == null || o.getOrderIndex() == null) {
            throw new RuntimeException("Compared non-order processing results");
        }
        return this.getOrderIndex().compareTo(o.getOrderIndex());
    }

    public void validate(SqlValidator validator) throws SqlValidationException {
        if (validator == null || this.allInputValues.isEmpty() || this.inputValues.isEmpty()) {
            return;
        }
        SqlValidationContext<?> validatorContext = null;
        for (String paramName : this.allInputValues) {
            SqlInputValue inputValue = this.inputValues.get(paramName);
            if (validatorContext == null) {
                validatorContext = validator.start(inputValue.getParentInputValue().getClass());
            }
            if (inputValue.getParentInputValue() == null || inputValue.getInputName() == null) continue;
            validator.validate(validatorContext, inputValue.getParentInputValue().getClass(), inputValue.getInputName(), inputValue.getInputValue());
        }
        SqlValidationResult<?> result = validator.finish(validatorContext);
        if (result != null) {
            throw new SqlValidationException(result);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlProcessResult[");
        sb.append(" add=").append(this.add);
        if (this.allInputValues != null && !this.allInputValues.isEmpty()) {
            sb.append(", allInputValue=").append(this.allInputValues.toString());
        }
        if (this.inputValues != null && !this.inputValues.isEmpty()) {
            sb.append(", inputValues=").append(this.inputValues.toString());
        }
        if (this.outputValues != null && !this.outputValues.isEmpty()) {
            sb.append(", outputValues=").append(this.outputValues.toString());
        }
        if (this.identities != null && !this.identities.isEmpty()) {
            sb.append(", identities=").append(this.identities.toString());
        }
        if (this.outValues != null && !this.outValues.isEmpty()) {
            sb.append(", outValues=").append(this.outValues.toString());
        }
        sb.append(", sql='").append((CharSequence)this.sql).append("'");
        sb.append(", orderIndex=").append(this.orderIndex);
        sb.append(", skipNextText=").append(this.skipNextText);
        sb.append(", logError=").append(this.logError);
        return sb.append("]").toString();
    }
}

