/*
 * Decompiled with CFR 0.152.
 */
package org.sysjava.linux;

import java.util.function.LongPredicate;
import org.sysjava.UnsafeAccess;

public interface NativeError {
    public String mnemonic();

    public String desc();

    public int errno();

    public static NativeError forErrno(int errno, Class<? extends NativeError> errorEnum) {
        for (NativeError error : errorEnum.getEnumConstants()) {
            if (errno != error.errno()) continue;
            return error;
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkError(long errnoAddress, long result, LongPredicate errorCheck, Class<? extends NativeError> errorClass) {
        try {
            if (errorCheck.test(result)) {
                int errno = UnsafeAccess.UNSAFE.getInt(errnoAddress);
                NativeError nativeError = NativeError.forErrno(errno, errorClass);
                throw new NativeCallException(nativeError.mnemonic(), nativeError.desc(), nativeError.errno());
            }
        }
        finally {
            UnsafeAccess.UNSAFE.freeMemory(errnoAddress);
        }
    }

    public static class NativeCallException
    extends RuntimeException {
        public NativeCallException(String mnemonic, String desc, int errno) {
            super(mnemonic + ": " + desc + ". ERRNO: " + errno);
        }
    }
}

