/*
 * Decompiled with CFR 0.152.
 */
package org.sysjava.linux.memory;

import org.sysjava.SysJava;
import org.sysjava.UnsafeAccess;
import org.sysjava.linux.NativeError;
import org.sysjava.linux.memory.MLockError;
import sun.misc.Unsafe;

public class MLock {
    public static final Unsafe UNSAFE;

    public static void mlock(long addr, int len) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = MLock.mlock(addr, len, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r != 0L, MLockError.class);
    }

    public static void mlock2(long addr, int len, int flags) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = MLock.mlock2(addr, len, flags, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r != 0L, MLockError.class);
    }

    public static void munlock(long addr, int len) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = MLock.munlock(addr, len, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r != 0L, MLockError.class);
    }

    public static void mlockall(int flags) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = MLock.mlockall(flags, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r != 0L, MLockError.class);
    }

    public static void munlockall() {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = MLock.munlockall(errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r != 0L, MLockError.class);
    }

    private static native int mlock(long var0, int var2, long var3);

    private static native int mlock2(long var0, int var2, int var3, long var4);

    private static native int munlock(long var0, int var2, long var3);

    private static native int mlockall(int var0, long var1);

    private static native int munlockall(long var0);

    static {
        SysJava.loadNativeLib();
        UNSAFE = UnsafeAccess.UNSAFE;
    }

    public static class Flags {
        public static final int MCL_CURRENT = 1;
        public static final int MCL_FUTURE = 2;
        public static final int MCL_ONFAULT = 4;
    }
}

