/*
 * Decompiled with CFR 0.152.
 */
package org.sysjava.linux.memory;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import org.sysjava.SysJava;
import org.sysjava.UnsafeAccess;
import org.sysjava.linux.NativeError;
import org.sysjava.linux.memory.MmapError;
import sun.misc.Unsafe;

public class Mmap {
    public static final Unsafe UNSAFE;
    public static final int MAP_FAILED = -1;

    public static long mmap(FileDescriptor fileDesc, long size, int prot, int flags, long offset) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int fd = fileDesc != null ? Mmap.getFD(fileDesc) : 0;
        long result = Mmap.mmap(fd, size, prot, flags, offset, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r == -1L, MmapError.class);
        return result;
    }

    public static void munmap(long address, long size) {
        long errnoAddress = UNSAFE.allocateMemory(4L);
        int result = Mmap.unmap(address, size, errnoAddress);
        NativeError.checkError(errnoAddress, result, r -> r == -1L, MmapError.class);
    }

    private static int getFD(FileDescriptor fileDesc) {
        if (fileDesc == null) {
            return -1;
        }
        try {
            Field fdField = FileDescriptor.class.getDeclaredField("fd");
            fdField.setAccessible(true);
            return (Integer)fdField.get(fileDesc);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to obtain integer fd for file descriptor " + fileDesc, e);
        }
    }

    private static native long mmap(int var0, long var1, int var3, int var4, long var5, long var7);

    private static native int unmap(long var0, long var2, long var4);

    static {
        SysJava.loadNativeLib();
        UNSAFE = UnsafeAccess.UNSAFE;
    }

    public static class Flags {
        public static final int MAP_SHARED = 1;
        public static final int MAP_PRIVATE = 2;
        public static final int MAP_FIXED = 16;
        public static final int MAP_ANONYMOUS = 32;
        public static final int MAP_GROWSDOWN = 256;
        public static final int MAP_LOCKED = 8192;
        public static final int MAP_NONBLOCK = 65536;
        public static final int MAP_NORESERVE = 16384;
        public static final int MAP_POPULATE = 32768;
        public static final int MAP_HUGETLB = 262144;
    }

    public static class Prot {
        public static final int PROT_NONE = 0;
        public static final int PROT_READ = 1;
        public static final int PROT_WRITE = 2;
        public static final int PROT_EXEC = 4;
    }
}

