/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.testobject.api.TestObjectClient;
import org.testobject.rest.api.AppVersionResourceImpl;
import org.testobject.rest.api.DeviceDescriptorsResourceImpl;
import org.testobject.rest.api.QualityReportResourceImpl;
import org.testobject.rest.api.SessionReportResourceImpl;
import org.testobject.rest.api.TestSuiteReportResourceImpl;
import org.testobject.rest.api.TestSuiteResourceImpl;
import org.testobject.rest.api.UploadResourceImpl;
import org.testobject.rest.api.UserResourceImpl;
import org.testobject.rest.api.model.DeviceDescriptor;
import org.testobject.rest.api.model.PaginationObject;
import org.testobject.rest.api.model.SessionReport;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.AppVersionResource;
import org.testobject.rest.api.resource.DeviceDescriptorsResource;
import org.testobject.rest.api.resource.QualityReportResource;
import org.testobject.rest.api.resource.SessionReportResource;
import org.testobject.rest.api.resource.TestSuiteReportResource;
import org.testobject.rest.api.resource.TestSuiteResource;
import org.testobject.rest.api.resource.UploadResource;
import org.testobject.rest.api.resource.UserResource;

public class TestObjectRemoteClient
implements TestObjectClient {
    private final UserResource user;
    private final UploadResource upload;
    private final AppVersionResource appVersion;
    private final TestSuiteResource testSuite;
    private final TestSuiteReportResource testSuiteReport;
    private final QualityReportResource qualityReport;
    private final SessionReportResource sessionReport;
    private final DeviceDescriptorsResource deviceDescriptors;
    private final Client client;

    public TestObjectRemoteClient(String baseUrl, TestObjectClient.ProxySettings proxySettings) {
        X509HostnameVerifier defaultHostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslConfig.createSSLContext(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, defaultHostnameVerifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.apache.client.connectionManager", (Object)new PoolingHttpClientConnectionManager(registry));
        ApacheConnectorProvider connector = new ApacheConnectorProvider();
        config.connectorProvider((ConnectorProvider)connector);
        config.register(MultiPartFeature.class);
        config.register(JacksonFeature.class);
        if (proxySettings != null) {
            config.getProperties().put("jersey.config.client.proxy.uri", "http://" + proxySettings.getHost() + ":" + proxySettings.getPort());
            if (proxySettings.getUsername() != null) {
                config.getProperties().put("jersey.config.client.proxy.username", proxySettings.getUsername());
                config.getProperties().put("jersey.config.client.proxy.password", proxySettings.getPassword());
            }
        }
        SSLContext sslContext = sslConfig.createSSLContext();
        ClientBuilder.newBuilder().sslContext(sslContext);
        this.client = ClientBuilder.newClient((Configuration)config);
        WebTarget resource = this.client.target(baseUrl);
        this.user = new UserResourceImpl(resource);
        this.upload = new UploadResourceImpl(resource);
        this.appVersion = new AppVersionResourceImpl(resource);
        this.testSuite = new TestSuiteResourceImpl(resource);
        this.testSuiteReport = new TestSuiteReportResourceImpl(resource);
        this.qualityReport = new QualityReportResourceImpl(resource);
        this.deviceDescriptors = new DeviceDescriptorsResourceImpl(resource);
        this.sessionReport = new SessionReportResourceImpl(resource);
    }

    @Override
    public void login(String username, String password) {
        this.user.login(username, password);
    }

    @Override
    public void updateInstrumentationTestSuite(String user, String project, long testSuite, File appApk, File testApk, TestSuiteResource.InstrumentationTestSuiteRequest request) {
        String testUploadId;
        String appUploadId = this.upload.uploadFile(user, project, appApk).replace("\"", "");
        request.testUploadId = testUploadId = this.upload.uploadFile(user, project, testApk).replace("\"", "");
        request.appUploadId = appUploadId;
        this.testSuite.updateInstrumentationTestSuite(user, project, testSuite, request);
    }

    @Override
    public Long createInstrumentationTestSuite(String user, String project, long testSuite, File appApk, File testApk, TestSuiteResource.InstrumentationTestSuiteRequest instrumentationTestSuiteRequest) {
        String appUploadId = this.upload.uploadFile(user, project, appApk).replace("\"", "");
        String testUploadId = this.upload.uploadFile(user, project, testApk).replace("\"", "");
        instrumentationTestSuiteRequest.appUploadId = appUploadId;
        instrumentationTestSuiteRequest.testUploadId = testUploadId;
        return this.testSuite.createInstrumentationTestSuite(user, project, testSuite, instrumentationTestSuiteRequest);
    }

    @Override
    public long startInstrumentationTestSuite(String user, String project, long testSuite) {
        return this.testSuite.runInstrumentationTestSuite(user, project, testSuite);
    }

    @Override
    public TestSuiteReport waitForSuiteReport(String user, String project, long testSuiteReportId) {
        return this.waitForSuiteReport(user, project, testSuiteReportId, TimeUnit.MINUTES.toMillis(60L), TimeUnit.SECONDS.toMillis(30L));
    }

    public TestSuiteReport waitForSuiteReport(String user, String project, long testSuiteReportId, long waitTimeoutMs, long sleepTimeMs) {
        long start = this.now();
        while (this.now() - start < waitTimeoutMs) {
            TestSuiteReport testSuiteReport = this.testSuiteReport.getReport(user, project, testSuiteReportId, "application/json");
            if (!testSuiteReport.isRunning()) {
                return testSuiteReport;
            }
            this.sleep(sleepTimeMs);
        }
        throw new IllegalStateException("unable to get test suite report result after 60min");
    }

    @Override
    public String readTestSuiteXMLReport(String user, String project, long testSuiteReportId) {
        return this.testSuiteReport.getXMLReport(user, project, testSuiteReportId);
    }

    @Override
    public void createAppVersion(String userId, String projectId, File appApk) {
        String appUploadId = this.upload.uploadFile(userId, projectId, appApk).replace("\"", "");
        this.appVersion.createAppVersion(userId, projectId, new AppVersionResource.CreateAppVersionRequest(appUploadId));
    }

    @Override
    public long startQualityReport(String userId, String projectId) {
        return this.qualityReport.startQualityReport(userId, projectId);
    }

    @Override
    public PaginationObject<SessionReport> getSessionReport(String user) {
        return this.sessionReport.getSessionReport(user);
    }

    @Override
    public PaginationObject<SessionReport> getSessionReport(String user, String userId, long offset, int limit, int lastDays) {
        return this.sessionReport.getSessionReport(user, userId, offset, limit, lastDays);
    }

    @Override
    public List<DeviceDescriptor> listDevices() {
        return this.deviceDescriptors.listDevices();
    }

    private void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.client.close();
    }
}

