/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl;

import java.util.Locale;
import org.testobject.external.apache.http.HttpResponse;
import org.testobject.external.apache.http.HttpResponseFactory;
import org.testobject.external.apache.http.ProtocolVersion;
import org.testobject.external.apache.http.ReasonPhraseCatalog;
import org.testobject.external.apache.http.StatusLine;
import org.testobject.external.apache.http.annotation.Immutable;
import org.testobject.external.apache.http.impl.EnglishReasonPhraseCatalog;
import org.testobject.external.apache.http.message.BasicHttpResponse;
import org.testobject.external.apache.http.message.BasicStatusLine;
import org.testobject.external.apache.http.protocol.HttpContext;
import org.testobject.external.apache.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

