/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.testobject.external.apache.http.HttpException;
import org.testobject.external.apache.http.HttpHost;
import org.testobject.external.apache.http.HttpRequest;
import org.testobject.external.apache.http.annotation.ThreadSafe;
import org.testobject.external.apache.http.client.ClientProtocolException;
import org.testobject.external.apache.http.client.config.RequestConfig;
import org.testobject.external.apache.http.client.methods.CloseableHttpResponse;
import org.testobject.external.apache.http.client.methods.Configurable;
import org.testobject.external.apache.http.client.methods.HttpExecutionAware;
import org.testobject.external.apache.http.client.methods.HttpRequestWrapper;
import org.testobject.external.apache.http.client.protocol.HttpClientContext;
import org.testobject.external.apache.http.conn.ClientConnectionManager;
import org.testobject.external.apache.http.conn.ClientConnectionRequest;
import org.testobject.external.apache.http.conn.HttpClientConnectionManager;
import org.testobject.external.apache.http.conn.ManagedClientConnection;
import org.testobject.external.apache.http.conn.routing.HttpRoute;
import org.testobject.external.apache.http.conn.scheme.SchemeRegistry;
import org.testobject.external.apache.http.impl.DefaultConnectionReuseStrategy;
import org.testobject.external.apache.http.impl.client.CloseableHttpClient;
import org.testobject.external.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.testobject.external.apache.http.impl.execchain.MinimalClientExec;
import org.testobject.external.apache.http.params.BasicHttpParams;
import org.testobject.external.apache.http.params.HttpParams;
import org.testobject.external.apache.http.protocol.BasicHttpContext;
import org.testobject.external.apache.http.protocol.HttpContext;
import org.testobject.external.apache.http.protocol.HttpRequestExecutor;
import org.testobject.external.apache.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

