/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.external.apache.http.impl.conn;

import java.net.InetAddress;
import org.testobject.external.apache.http.HttpException;
import org.testobject.external.apache.http.HttpHost;
import org.testobject.external.apache.http.HttpRequest;
import org.testobject.external.apache.http.ProtocolException;
import org.testobject.external.apache.http.annotation.Immutable;
import org.testobject.external.apache.http.client.config.RequestConfig;
import org.testobject.external.apache.http.client.protocol.HttpClientContext;
import org.testobject.external.apache.http.conn.SchemePortResolver;
import org.testobject.external.apache.http.conn.UnsupportedSchemeException;
import org.testobject.external.apache.http.conn.routing.HttpRoute;
import org.testobject.external.apache.http.conn.routing.HttpRoutePlanner;
import org.testobject.external.apache.http.impl.conn.DefaultSchemePortResolver;
import org.testobject.external.apache.http.protocol.HttpContext;
import org.testobject.external.apache.http.util.Args;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

