/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.rest.api.resource.v2;

import java.util.Base64;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;

public class InstrumentationResource {
    private final WebTarget target;

    public InstrumentationResource(WebTarget target) {
        this.target = target;
    }

    public StartInstrumentationResponse createAndStartXCUITestInstrumentation(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.target.path("v2").path("instrumentation").path("xcuitest").request("application/json").header("Authorization", this.getApiKeyHeader(apiKey)).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    public StartInstrumentationResponse createAndStartXCUITestInstrumentation(String apiKey, DynamicInstrumentationRequestData requestData) {
        return this.target.path("v2").path("instrumentation").path("xcuitest").path("dynamic").request("application/json").header("Authorization", this.getApiKeyHeader(apiKey)).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    public StartInstrumentationResponse createAndStartAndroidInstrumentation(String apiKey, StaticInstrumentationRequestData requestData) {
        return this.target.path("v2").path("instrumentation").path("android").request("application/json").header("Authorization", this.getApiKeyHeader(apiKey)).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    public StartInstrumentationResponse createAndStartAndroidInstrumentation(String apiKey, DynamicInstrumentationRequestData requestData) {
        return this.target.path("v2").path("instrumentation").path("android").path("dynamic").request("application/json").header("Authorization", this.getApiKeyHeader(apiKey)).post(Entity.json(requestData), StartInstrumentationResponse.class);
    }

    public String getJUnitReport(String apiKey, long reportId) {
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).path("junitreport").request("application/xml").header("Authorization", this.getApiKeyHeader(apiKey)).get(String.class);
    }

    public String getJUnitReport(String apiKey, List<Long> reportIds) {
        return this.target.path("v2").path("instrumentation").path("junitreport").request("application/xml").header("Authorization", this.getApiKeyHeader(apiKey)).post(Entity.json(reportIds), String.class);
    }

    public InstrumentationReport getTestReport(String apiKey, long reportId) {
        return this.target.path("v2").path("instrumentation").path("testreport").path(Long.toString(reportId)).request("application/json").header("Authorization", this.getApiKeyHeader(apiKey)).get(InstrumentationReport.class);
    }

    private String getApiKeyHeader(String apiKey) {
        return "Basic " + Base64.getEncoder().encodeToString(("user:" + apiKey).getBytes());
    }
}

