/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.util.List;
import org.tinygroup.appconfig.AppConfig;
import org.tinygroup.appconfig.util.AppConfigUtil;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.bu.BusinessUnitManagerFactory;
import org.tinygroup.bu.util.BusinessUnitUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuProcessor
implements ApplicationProcessor {
    private static final String BU_MANAGEMENT_NODE_NAME = "bu-management";
    private static Logger logger = LoggerFactory.getLogger(BuProcessor.class);
    private XmlNode buNode;
    private Application application;

    public String getNodeName() {
        return BU_MANAGEMENT_NODE_NAME;
    }

    public void setConfiguration(XmlNode xmlNode) {
        this.buNode = xmlNode;
    }

    public XmlNode getConfiguration() {
        return this.buNode;
    }

    public void start() {
        logger.logMessage(LogLevel.INFO, "\u542f\u52a8BuProcessor");
        AppConfigUtil.config((AppConfig)this, (AppConfig)BusinessUnitManagerFactory.getManager());
        BusinessUnitManagerFactory.getManager().install();
        logger.logMessage(LogLevel.INFO, "\u542f\u52a8BuProcessor\u5b8c\u6bd5");
    }

    public void stop() {
    }

    public String getPath() {
        String path;
        if (this.buNode != null && (path = this.buNode.getAttribute("bu-path")) != null && path.length() > 0) {
            return path;
        }
        return BusinessUnitUtil.getBuDir();
    }

    private void loadConfigResolverProcessors() {
        if (this.buNode == null) {
            return;
        }
        NameFilter nameFilter = new NameFilter((Node)this.buNode);
        XmlNode fileProcessors = (XmlNode)nameFilter.findNode("file-processors");
        this.loadResolverProcessor(fileProcessors, BusinessUnitManagerFactory.getManager().getResourceProcessors());
        XmlNode fileRemoveProcessors = (XmlNode)nameFilter.findNode("file-remove-processor");
        this.loadResolverProcessor(fileRemoveProcessors, BusinessUnitManagerFactory.getManager().getResourceRemoveProcessors());
    }

    private void loadResolverProcessor(XmlNode fileProcessorsNode, List<FileProcessor> processors) {
        if (fileProcessorsNode == null) {
            return;
        }
        NameFilter nameFilter = new NameFilter((Node)fileProcessorsNode);
        List fileProcessorNodes = nameFilter.findNodeList("file-processor");
        if (fileProcessorNodes == null) {
            return;
        }
        for (XmlNode fileResolver : fileProcessorNodes) {
            String className;
            String enable = fileResolver.getAttribute("enable");
            if (enable != null && enable.equalsIgnoreCase("false") || (className = fileResolver.getAttribute("class-name")) == null || className.length() <= 0) continue;
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u63d2\u4ef6\u6587\u4ef6\u5904\u7406\u5668[{0}]...", new Object[]{className});
            this.loadFileProcessor(className, fileResolver, processors);
            logger.logMessage(LogLevel.INFO, "\u6587\u4ef6\u5904\u7406\u5668[{0}]\u52a0\u8f7d\u5b8c\u6bd5", new Object[]{className});
        }
    }

    protected ClassLoader getThisClassLoader() {
        return this.getClass().getClassLoader();
    }

    private void loadFileProcessor(String className, XmlNode fileResolverNode, List<FileProcessor> processors) {
        try {
            FileProcessor fileProcessor = (FileProcessor)this.getThisClassLoader().loadClass(className).newInstance();
            if (fileProcessor instanceof AppConfig) {
                AppConfig appconfig = (AppConfig)fileProcessor;
                if (this.buNode != null) {
                    NameFilter nameFilter = new NameFilter((Node)this.buNode);
                    XmlNode fileConfig = (XmlNode)nameFilter.findNode(appconfig.getNodeName());
                    appconfig.setConfiguration(fileConfig);
                }
            }
            processors.add(fileProcessor);
        }
        catch (Exception e) {
            logger.errorMessage("\u52a0\u8f7d[{0}]\u5931\u8d25\uff01", (Throwable)e, new Object[]{className});
        }
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

