/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.xmlparser.node.XmlNode;

public class FileMonitorProcessor
implements ApplicationProcessor {
    private static final int DEFAULT_INTERVAL = 5;
    private static final String FILE_MONITOR_NODE_NAME = "file-monitor";
    private static Logger logger = LoggerFactory.getLogger(FileMonitorProcessor.class);
    private FileMonitorThread thread = null;
    private int interval = 5;
    private boolean enable = false;
    private XmlNode fileMonitor;
    private Application application;

    public void setConfiguration(XmlNode fileMonitor) {
        this.fileMonitor = fileMonitor;
        if (fileMonitor != null) {
            String enableString;
            String strInterrupt = fileMonitor.getAttribute("interval");
            if (strInterrupt != null && strInterrupt.length() > 0) {
                this.interval = Integer.parseInt(strInterrupt);
            }
            if ((enableString = fileMonitor.getAttribute("enable")) != null && enableString.length() > 0) {
                this.enable = Boolean.valueOf(enableString);
            }
        }
    }

    public void start() {
        if (this.enable) {
            if (this.thread != null) {
                this.thread.stop = true;
            }
            this.thread = new FileMonitorThread();
            this.thread.run();
        }
    }

    public void stop() {
        if (this.enable && this.thread != null && this.thread.isAlive()) {
            this.thread.stop = true;
        }
    }

    public String getNodeName() {
        return FILE_MONITOR_NODE_NAME;
    }

    public XmlNode getConfiguration() {
        return this.fileMonitor;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    private class FileMonitorThread
    extends Thread {
        private static final int MILLISECOND_PER_SECOND = 1000;
        private volatile boolean stop = false;

        private FileMonitorThread() {
        }

        public void run() {
            while (!this.stop) {
                try {
                    FileMonitorThread.sleep(FileMonitorProcessor.this.interval * 1000);
                    logger.logMessage(LogLevel.INFO, "\u5b9a\u65f6\u626b\u63cf\u6587\u4ef6\u53d8\u5316......");
                    FileResolver resolver = (FileResolver)SpringUtil.getBean((String)"fileResolver");
                    resolver.refresh();
                    logger.logMessage(LogLevel.INFO, "\u5b9a\u65f6\u626b\u63cf\u6587\u4ef6\u7ed3\u675f.");
                }
                catch (InterruptedException e) {
                    logger.errorMessage(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

