/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.util.List;
import org.tinygroup.appconfig.AppConfig;
import org.tinygroup.appconfig.util.AppConfigUtil;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.node.XmlNode;

public class FileResolverProcessor
implements ApplicationProcessor {
    private static final String FILE_RESOLVER_NODE_NAME = "file-resolver-configuration";
    private static Logger logger = LoggerFactory.getLogger(FileResolverProcessor.class);
    private XmlNode fileResolverConfiguration;
    private Application application;
    private FileResolver fileResolver;

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setConfiguration(XmlNode fileResolverNodes) {
        this.fileResolverConfiguration = fileResolverNodes;
    }

    public void start() {
        if (this.fileResolverConfiguration != null && this.fileResolverConfiguration.getContent() != null) {
            this.loadClassPath();
            this.configFileResolvers();
        } else {
            logger.logMessage(LogLevel.INFO, "\u6ca1\u6709\u6587\u4ef6\u641c\u7d22\u914d\u7f6e\u4fe1\u606f");
        }
        this.fileResolver.resolve();
    }

    private void loadClassPath() {
        this.setResolverClassPath();
        this.setResolverOrder();
        String threadCount = this.fileResolverConfiguration.getAttribute("thread-count");
        this.fileResolver.setFileProcessorThreadNum(this.getThreadNum(threadCount));
        NameFilter nameFilter = new NameFilter((Node)this.fileResolverConfiguration);
        List classPaths = nameFilter.findNodeList("class-path");
        for (XmlNode classPath : classPaths) {
            String path = classPath.getAttribute("path");
            if (path == null || path.length() <= 0) continue;
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u624b\u5de5\u914d\u7f6eclasspath: [{0}]...", new Object[]{path});
            this.fileResolver.addManualClassPath(path);
        }
        List skipPatterns = nameFilter.findNodeList("skip-pattern");
        for (XmlNode skipPatter : skipPatterns) {
            String pattern = skipPatter.getAttribute("pattern");
            if (pattern == null || pattern.length() <= 0) continue;
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u5ffd\u7565\u6587\u4ef6\u6b63\u5219\u8868\u8fbe\u5f0f: [{0}]...", new Object[]{pattern});
            this.fileResolver.addSkipPathPattern(pattern);
        }
    }

    private void setResolverOrder() {
        String order = this.fileResolverConfiguration.getAttribute("order");
        if (order != null && order.equalsIgnoreCase("true")) {
            this.fileResolver.setOrder(true);
        } else {
            this.fileResolver.setOrder(false);
        }
    }

    private void setResolverClassPath() {
        String resolverClassPath = this.fileResolverConfiguration.getAttribute("resolve-classpath");
        if (resolverClassPath != null && resolverClassPath.equalsIgnoreCase("true")) {
            this.fileResolver.setClassPathResolve(true);
        } else {
            this.fileResolver.setClassPathResolve(false);
        }
    }

    private void configFileResolvers() {
        for (FileProcessor processor : this.fileResolver.getFileProcessorList()) {
            if (!(processor instanceof AppConfig)) continue;
            AppConfigUtil.config((AppConfig)this, (AppConfig)((AppConfig)processor));
        }
    }

    public void stop() {
    }

    public String getNodeName() {
        return FILE_RESOLVER_NODE_NAME;
    }

    public XmlNode getConfiguration() {
        return this.fileResolverConfiguration;
    }

    private int getThreadNum(String threadNum) {
        int fileProcessorThreadNum = 1;
        if (threadNum != null) {
            try {
                fileProcessorThreadNum = Integer.parseInt(threadNum);
                if (fileProcessorThreadNum <= 0) {
                    fileProcessorThreadNum = 1;
                }
            }
            catch (Exception e) {
                fileProcessorThreadNum = 1;
            }
        }
        return fileProcessorThreadNum;
    }
}

