/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.utils.props.PropertyLoader;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.xmlparser.node.XmlNode;

public class JcsCacheProcessor
implements ApplicationProcessor {
    private static final String JCS_CONFIG_NAME = "jcs-config";
    private static Logger logger = LoggerFactory.getLogger(JcsCacheProcessor.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "cache.ccf";
    private XmlNode jcsConfig;
    private Application application;
    private boolean enable = false;

    public String getNodeName() {
        return JCS_CONFIG_NAME;
    }

    public void setConfiguration(XmlNode xmlNode) {
        String enableString;
        this.jcsConfig = xmlNode;
        if (this.jcsConfig != null && (enableString = this.jcsConfig.getAttribute("enable")) != null && enableString.length() > 0) {
            this.enable = Boolean.valueOf(enableString);
        }
    }

    public XmlNode getConfiguration() {
        return this.jcsConfig;
    }

    public void start() {
        if (this.enable) {
            this.startCluster();
        }
    }

    private void startCluster() {
        int registryPort = 1101;
        try {
            Properties props = PropertyLoader.loadProperties((String)DEFAULT_PROPS_FILE_NAME);
            if (props != null) {
                String portS = props.getProperty("registry.port", String.valueOf(1101));
                try {
                    registryPort = Integer.parseInt(portS);
                }
                catch (NumberFormatException e) {
                    logger.errorMessage("Problem converting port to an int.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.errorMessage("Problem loading props.", (Throwable)e);
        }
        try {
            String registryHost = InetAddress.getLocalHost().getHostAddress();
            logger.logMessage(LogLevel.DEBUG, "registryHost =[{}]", new Object[]{registryHost});
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                logger.logMessage(LogLevel.WARN, "The local address [{}] is INVALID.  Other machines must be able to use the address to reach this server.", new Object[]{registryHost});
            }
            try {
                LocateRegistry.createRegistry(registryPort);
            }
            catch (RemoteException e) {
                logger.errorMessage("Problem creating registry.  It may already be started. {}", (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Exception t) {
                logger.errorMessage("Problem creating registry.", (Throwable)t);
            }
            try {
                RemoteCacheServerFactory.startup((String)registryHost, (int)registryPort, (String)"/cache.ccf");
            }
            catch (IOException e) {
                logger.errorMessage("Problem starting remote cache server.", (Throwable)e);
            }
            catch (Exception t) {
                logger.errorMessage("Problem starting remote cache server.", (Throwable)t);
            }
        }
        catch (UnknownHostException e) {
            logger.errorMessage("Could not get local address to use for the registry!", (Throwable)e);
        }
    }

    public void stop() {
        logger.logMessage(LogLevel.INFO, "Shutting down remote cache ");
        CompositeCacheManager.getInstance().shutDown();
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

