/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.xmlparser.node.XmlNode;

public class GreetingProcessor
implements ApplicationProcessor {
    private static final String GREETINGS_NODE_NAME = "greetings";
    private static Logger logger = LoggerFactory.getLogger(GreetingProcessor.class);
    private XmlNode greetingNode;
    private Application application;

    public void setConfiguration(XmlNode greetingNode) {
        this.greetingNode = greetingNode;
    }

    private void showLogo() {
        logger.logMessage(LogLevel.INFO, "********************************************************");
        logger.logMessage(LogLevel.INFO, "  H U N D S U N   O P E N S O U R C E                   ");
        logger.logMessage(LogLevel.INFO, "********************************************************");
        logger.logMessage(LogLevel.INFO, "                       VERSIN 0.0.1          ");
        logger.logMessage(LogLevel.INFO, "********************************************************");
    }

    public void start() {
        if (this.greetingNode != null && this.greetingNode.getContent() != null) {
            String[] greetings;
            for (String greeting : greetings = this.greetingNode.getContent().split("\n")) {
                if ((greeting = greeting.trim()).length() <= 0) continue;
                logger.logMessage(LogLevel.INFO, greeting);
            }
        } else {
            this.showLogo();
        }
    }

    public void stop() {
    }

    public String getNodeName() {
        return GREETINGS_NODE_NAME;
    }

    public XmlNode getConfiguration() {
        return this.greetingNode;
    }

    public void setApplication(Application application) {
        this.application = application;
    }
}

