/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.io.File;
import java.util.List;
import org.tinygroup.appconfig.AppConfig;
import org.tinygroup.appconfig.util.AppConfigUtil;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMgtProcessor
implements ApplicationProcessor {
    private static final String PLUGIN_MANAGEMENT_NODE_NAME = "plugin-management";
    private static Logger logger = LoggerFactory.getLogger(PluginMgtProcessor.class);
    private XmlNode pluginMgtNode;
    private PluginManager pluginManager;
    private Application application;

    public void setApplication(Application application) {
        this.application = application;
    }

    public void stop() {
        if (this.pluginManager != null) {
            this.pluginManager.stop();
        }
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void start() {
        logger.logMessage(LogLevel.INFO, "\u542f\u52a8\u63d2\u4ef6\u7ba1\u7406\u5668");
        this.pluginManager.load(null);
        AppConfigUtil.config((AppConfig)this, (AppConfig)this.pluginManager);
        this.pluginManager.start();
        logger.logMessage(LogLevel.INFO, "\u542f\u52a8\u63d2\u4ef6\u7ba1\u7406\u5668\u6210\u529f");
    }

    private void loadPluginResolverProcessors(String processorRootNodeName, List<FileProcessor> processors) {
        NameFilter nameFilter = new NameFilter((Node)this.pluginMgtNode);
        XmlNode fileProcessorsNode = (XmlNode)nameFilter.findNode(processorRootNodeName);
        if (fileProcessorsNode == null) {
            return;
        }
        NameFilter nodeNameFileter = new NameFilter((Node)fileProcessorsNode);
        List fileProcessors = nodeNameFileter.findNodeList("file-processor");
        if (fileProcessors == null) {
            return;
        }
        for (XmlNode fileResolver : fileProcessors) {
            String className;
            String enable = fileResolver.getAttribute("enable");
            if (enable != null && enable.equalsIgnoreCase("false") || (className = fileResolver.getAttribute("class-name")) == null || className.length() <= 0) continue;
            logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7d\u63d2\u4ef6\u6587\u4ef6\u5904\u7406\u5668[{0}]...", new Object[]{className});
            this.loadFileResolver(className, fileResolver, processors);
            logger.logMessage(LogLevel.INFO, "\u6587\u4ef6\u5904\u7406\u5668[{0}]\u52a0\u8f7d\u5b8c\u6bd5", new Object[]{className});
        }
    }

    private void loadFileResolver(String className, XmlNode fileResolverNode, List<FileProcessor> processors) {
        try {
            FileProcessor fileResolver = (FileProcessor)Class.forName(className).newInstance();
            if (fileResolver instanceof AppConfig) {
                AppConfigUtil.config((AppConfig)this, (AppConfig)((AppConfig)fileResolver));
            }
            processors.add(fileResolver);
        }
        catch (Exception e) {
            logger.errorMessage("\u52a0\u8f7d[{0}]\u5931\u8d25\uff01", (Throwable)e, new Object[]{className});
        }
    }

    public void setConfiguration(XmlNode xmlNode) {
        this.pluginMgtNode = xmlNode;
    }

    private String getWebRoot() {
        String webRoot = (String)this.application.getContext().get("TINY_WEBROOT");
        String path = "";
        path = webRoot != null ? webRoot + File.separator + "WEB-INF" : PluginMgtProcessor.class.getClassLoader().getResource("").getPath();
        return path;
    }

    public String getNodeName() {
        return PLUGIN_MANAGEMENT_NODE_NAME;
    }

    public XmlNode getConfiguration() {
        return this.pluginMgtNode;
    }
}

