/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.configmanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.BOMInputStream;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyProcessorConfigManager {
    public static final String TINY_PROCESSOR_CONFIGMANAGER = "tinyProcessorConfigManager";
    private List<XmlNode> configs = new ArrayList<XmlNode>();
    private XmlNode applicationConfig;
    private static Logger logger = LoggerFactory.getLogger(TinyProcessorConfigManager.class);

    public void addConfig(FileObject fileObject) {
        String filePath = fileObject.getPath();
        logger.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dtiny-processor\u5904\u7406\u5668\u914d\u7f6e\u6587\u4ef6[{0}] ....", new Object[]{filePath});
        BOMInputStream inputStream = null;
        try {
            inputStream = new BOMInputStream(fileObject.getInputStream());
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            inputStream.close();
            fileObject.getInputStream().close();
            String content = new String(bytes, "UTF-8");
            logger.logMessage(LogLevel.INFO, "tiny-processor\u5904\u7406\u5668\u914d\u7f6e\u6587\u4ef6<{0}>\u52a0\u8f7d\u5b8c\u6210\u3002.", new Object[]{filePath});
            XmlNode root = (XmlNode)new XmlStringParser().parse(content).getRoot();
            this.configs.add(root);
        }
        catch (Exception e) {
            logger.errorMessage("\u8f7d\u5165tiny-processor\u914d\u7f6e\u6587\u4ef6<{}>\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e, new Object[]{filePath});
            throw new RuntimeException(e);
        }
    }

    public void setApplicationConfig(XmlNode xmlNode) {
        this.applicationConfig = xmlNode;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public List<XmlNode> getConfigs() {
        return this.configs;
    }
}

