/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.util.List;
import java.util.Map;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.cache.Cache;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.tinydb.BeanOperatorManager;
import org.tinygroup.tinydb.config.SchemaConfig;
import org.tinygroup.xmlparser.node.XmlNode;

public class BeanManagerProcessor
implements ApplicationProcessor {
    private static final String DEFAULT_SCHEMA = "default-schema";
    private static final String KEY_TYPE = "key-type";
    private static final String TABLE_NAME_PATTERN = "table-name-pattern";
    private static final String BEAN_NAME = "bean-name";
    private static final String BEAN_MANAGER_NODE_NAME = "bean-manager-config";
    private static final String SCHEMA = "schema";
    private static final String BEAN_OPERATE_CONFIG = "bean-opertate-config";
    private XmlNode xmlNode;
    private Cache cache;

    public String getNodeName() {
        return BEAN_MANAGER_NODE_NAME;
    }

    public void setConfiguration(XmlNode xmlNode) {
        this.xmlNode = xmlNode;
    }

    public XmlNode getConfiguration() {
        return this.xmlNode;
    }

    public void start() {
        if (this.xmlNode != null) {
            NameFilter nameFilter = new NameFilter((Node)this.xmlNode);
            List nodes = nameFilter.findNodeList(BEAN_OPERATE_CONFIG);
            BeanOperatorManager manager = (BeanOperatorManager)SpringUtil.getBean((String)"beanOperatorManager");
            String defaultSchema = this.xmlNode.getAttribute(DEFAULT_SCHEMA);
            manager.setMainSchema(defaultSchema);
            for (XmlNode node : nodes) {
                String schema = node.getAttribute(SCHEMA);
                String beanName = node.getAttribute(BEAN_NAME);
                String tableNamePattern = node.getAttribute(TABLE_NAME_PATTERN);
                String keyType = node.getAttribute(KEY_TYPE);
                manager.registerSchemaConfig(new SchemaConfig(schema, beanName, keyType, tableNamePattern));
                manager.loadTablesFromSchemas();
                manager.initBeansConfiguration();
            }
            if (this.cache != null) {
                Map schemaTableConfigurations = manager.getTableConfigurations();
                for (String schema : schemaTableConfigurations.keySet()) {
                    Map tableConfigs = (Map)schemaTableConfigurations.get(schema);
                    for (String tableName : tableConfigs.keySet()) {
                        this.cache.put(schema, tableName, tableConfigs.get(tableName));
                    }
                }
            }
        }
    }

    public void stop() {
    }

    public void setApplication(Application application) {
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

