/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.applicationprocessor.processor;

import java.util.List;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.exceptionhandler.ExceptionHandler;
import org.tinygroup.exceptionhandler.ExceptionHandlerManager;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.xmlparser.node.XmlNode;

public class ExceptionProcessor
implements ApplicationProcessor {
    private ExceptionHandlerManager manager;
    private XmlNode xmlNode;
    private static Logger logger = LoggerFactory.getLogger(ExceptionProcessor.class);

    public ExceptionHandlerManager getManager() {
        return this.manager;
    }

    public void setManager(ExceptionHandlerManager manager) {
        this.manager = manager;
    }

    public String getNodeName() {
        return "exception-config";
    }

    public void setConfiguration(XmlNode xmlNode) {
        logger.logMessage(LogLevel.INFO, "\u8bfb\u53d6exception-handler\u914d\u7f6e");
        this.xmlNode = xmlNode;
        this.parse(xmlNode);
        logger.logMessage(LogLevel.INFO, "\u8bfb\u53d6exception-handler\u914d\u7f6e\u5b8c\u6bd5");
    }

    private void parse(XmlNode xmlNode) {
        if (xmlNode == null) {
            logger.logMessage(LogLevel.INFO, "exception-handler\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        NameFilter nameFilter = new NameFilter((Node)xmlNode);
        List handlerList = nameFilter.findNodeList("exception-handler");
        for (XmlNode handler : handlerList) {
            String exception = handler.getAttribute("exception");
            String handlerBean = handler.getAttribute("handler");
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0exception-handler,Exception:{0},handerBean:{1}", new Object[]{exception, handlerBean});
            ExceptionHandler exceptionHandler = (ExceptionHandler)SpringUtil.getBean((String)handlerBean);
            try {
                this.manager.addHandler(exception, exceptionHandler);
            }
            catch (ClassNotFoundException e) {
                logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0exception-handler\u51fa\u9519,Exception\u7c7b:{0}\u627e\u4e0d\u5230", new Object[]{exception, handlerBean});
                continue;
            }
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0exception-handler,Exception:{0},handerBean:{1}\u5b8c\u6210", new Object[]{exception, handlerBean});
        }
    }

    public XmlNode getConfiguration() {
        return this.xmlNode;
    }

    public void start() {
    }

    public void stop() {
    }

    public void setApplication(Application application) {
    }
}

