/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent;

import java.lang.reflect.Method;
import org.tinygroup.context.Context;
import org.tinygroup.flow.ComponentInterface;
import org.tinygroup.flow.util.FlowElUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.springutil.SpringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallMethod
implements ComponentInterface {
    private Logger logger = LoggerFactory.getLogger(CallMethod.class);
    private String className;
    private String beanName;
    private String methodName;
    private String params;
    private String resultKey;

    public String getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void execute(Context context) {
        Object[] args = this.getArguments(context);
        Object result = null;
        if (this.beanName != null && !"".equals(this.beanName)) {
            result = this.execBeanMethod(args);
        } else if (this.className != null || !"".equals(this.beanName)) {
            result = this.execClassMethod(args);
        }
        if (this.resultKey != null && !"".equals(this.resultKey)) {
            context.put(this.resultKey, result);
        }
    }

    private Object execBeanMethod(Object[] args) {
        Object obj = SpringUtil.getBean((String)this.beanName);
        if (obj == null) {
            String info = String.format("\u627e\u4e0d\u5230bean::%s", this.beanName);
            this.logger.logMessage(LogLevel.ERROR, info);
            throw new RuntimeException(info);
        }
        Class<?> clazz = obj.getClass();
        Method method = this.getMethod(clazz, args);
        if (method == null) {
            String info = String.format("bean:%s\u4e2d\u6ca1\u6709\u65b9\u6cd5%s", this.beanName, this.methodName);
            this.logger.logMessage(LogLevel.ERROR, info);
            throw new RuntimeException(info);
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            String info = String.format("\u6267\u884cbean:%s\u4e2d\u65b9\u6cd5%s\u65f6\u51fa\u9519", this.beanName, this.methodName);
            this.logger.logMessage(LogLevel.ERROR, info);
            throw new RuntimeException(e);
        }
    }

    private Object execClassMethod(Object[] args) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            this.logger.errorMessage("\u83b7\u53d6\u7c7b:{className}\u5931\u8d25", (Throwable)e, new Object[]{this.className});
            throw new RuntimeException(e);
        }
        Method method = this.getMethod(clazz, args);
        if (method == null) {
            String info = String.format("class:%s\u4e2d\u6ca1\u6709\u65b9\u6cd5%s", this.className, this.methodName);
            this.logger.logMessage(LogLevel.ERROR, info);
            throw new RuntimeException(info);
        }
        try {
            return method.invoke(clazz, args);
        }
        catch (Exception e) {
            String info = String.format("\u6267\u884cclass:%s\u4e2d\u65b9\u6cd5%s\u65f6\u51fa\u9519", this.className, this.methodName);
            this.logger.logMessage(LogLevel.ERROR, info);
            throw new RuntimeException(e);
        }
    }

    private Method getMethod(Class<?> clazz, Object[] args) {
        for (Method m : clazz.getMethods()) {
            if (!this.methodName.equals(m.getName()) || m.getParameterTypes().length != args.length) continue;
            return m;
        }
        return null;
    }

    private Object[] getArguments(Context context) {
        Object[] args = null;
        if (this.params == null) {
            return args;
        }
        String[] paramArray = this.params.split(",");
        args = new Object[paramArray.length];
        for (int i = 0; i < paramArray.length; ++i) {
            args[i] = FlowElUtil.execute((String)paramArray[i], (Context)context);
        }
        return args;
    }
}

