/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.function.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.function.FunctionManagerFactory;
import org.tinygroup.function.config.DomainDefines;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class DomainFileProcessor
extends AbstractFileProcessor {
    private static final String DOMAIN_EXT_FILENAME = ".domain.xml";

    public boolean isMatch(FileObject fileObject) {
        boolean isMatch = false;
        if (fileObject.getFileName().endsWith(DOMAIN_EXT_FILENAME)) {
            isMatch = true;
        }
        return isMatch;
    }

    public void process() {
        FunctionManagerFactory functionManagerFactory = (FunctionManagerFactory)SpringUtil.getBean((String)"functionManagerFactory");
        XStream stream = XStreamFactory.getXStream((String)"domain");
        for (FileObject fileObject : this.fileObjects) {
            logger.logMessage(LogLevel.DEBUG, "\u6b63\u5728\u52a0\u8f7d\u9886\u57df\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            DomainDefines domainDefines = (DomainDefines)stream.fromXML(fileObject.getInputStream());
            functionManagerFactory.addDomainDefines(domainDefines);
            logger.logMessage(LogLevel.DEBUG, "\u52a0\u8f7d\u9886\u57df\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }

    public void process(ClassLoader loader) {
        this.process();
    }
}

