/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.function.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.function.FunctionManagerFactory;
import org.tinygroup.function.config.FunctionDefines;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class FunctionFileProcessor
extends AbstractFileProcessor {
    private static final String FUNCTION_EXT_FILENAME = ".function.xml";

    public boolean isMatch(FileObject fileObject) {
        boolean isMatch = false;
        if (fileObject.getFileName().endsWith(FUNCTION_EXT_FILENAME)) {
            isMatch = true;
        }
        return isMatch;
    }

    public void process() {
        FunctionManagerFactory functionManagerFactory = (FunctionManagerFactory)SpringUtil.getBean((String)"functionManagerFactory");
        XStream stream = XStreamFactory.getXStream((String)"function");
        for (FileObject fileObject : this.fileObjects) {
            logger.logMessage(LogLevel.DEBUG, "\u6b63\u5728\u52a0\u8f7d\u51fd\u6570\u914d\u7f6e\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            FunctionDefines functionDefines = (FunctionDefines)stream.fromXML(fileObject.getInputStream());
            functionManagerFactory.addFunctionDefines(functionDefines);
            logger.logMessage(LogLevel.DEBUG, "\u52a0\u8f7d\u51fd\u6570\u914d\u7f6e\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

