/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.function.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tinygroup.function.Function;
import org.tinygroup.function.FunctionManager;
import org.tinygroup.function.FunctionManagerFactory;
import org.tinygroup.function.config.DomainDefine;
import org.tinygroup.function.config.DomainDefines;
import org.tinygroup.function.config.FunctionDefine;
import org.tinygroup.function.config.FunctionDefines;
import org.tinygroup.springutil.SpringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionManagerFactoryImpl
implements FunctionManagerFactory {
    private static Map<String, FunctionManager> functionManagerMap = new HashMap<String, FunctionManager>();
    private static final String DEFAULT_GROUP = "";
    private Map<String, List<Function<?>>> groupMap = new HashMap();
    private Map<String, Map<String, List<Function<?>>>> domainMap = new HashMap();

    @Override
    public synchronized FunctionManager getFunctionManager(String domainName) {
        FunctionManager functionManager = functionManagerMap.get(domainName);
        if (functionManager == null) {
            functionManager = (FunctionManager)SpringUtil.getBean(FunctionManager.class);
            Map<String, List<Function<?>>> functionMap = this.domainMap.get(domainName);
            if (functionMap != null) {
                functionManager.setFunctionMap(functionMap);
            }
            functionManagerMap.put(domainName, functionManager);
        }
        return functionManager;
    }

    @Override
    public void addDomainDefines(DomainDefines domainDefines) {
        if (domainDefines.getDomainDefineList() != null) {
            for (DomainDefine domainDefine : domainDefines.getDomainDefineList()) {
                this.buildDomain(domainDefine);
            }
        }
    }

    private void buildDomain(DomainDefine domainDefine) {
        if (domainDefine.getGroupNames() != null) {
            String[] groupNameArray;
            for (String groupName : groupNameArray = domainDefine.getGroupNames().split(",")) {
                this.buildDomain(domainDefine.getDomainName(), groupName);
            }
        }
        this.buildDomain(domainDefine.getDomainName(), DEFAULT_GROUP);
    }

    private void buildDomain(String domainName, String groupName) {
        List<Function<?>> functionList = this.groupMap.get(groupName);
        if (functionList != null) {
            Map<String, List<Function<?>>> functionMap = this.domainMap.get(domainName);
            if (functionMap == null) {
                functionMap = new HashMap();
                this.domainMap.put(domainName, functionMap);
            }
            this.addToFunctionMap(functionMap, functionList);
        }
    }

    private void addToFunctionMap(Map<String, List<Function<?>>> functionMap, List<Function<?>> functionList) {
        for (Function<?> function : functionList) {
            List<Function<?>> funList = functionMap.get(function.getName());
            if (funList == null) {
                funList = new ArrayList();
                functionMap.put(function.getName(), funList);
            }
            funList.add(function);
        }
    }

    @Override
    public void addFunctionDefines(FunctionDefines functionDefines) {
        if (functionDefines.getFunctionDefineList() != null) {
            for (FunctionDefine functionDefine : functionDefines.getFunctionDefineList()) {
                this.addToFunctionMap(functionDefines, functionDefine);
            }
        }
    }

    private void addToFunctionMap(FunctionDefines functionDefines, FunctionDefine functionDefine) {
        List<Function<?>> functionList;
        String groupName = functionDefine.getGroupName();
        if (groupName == null) {
            groupName = functionDefines.getDefaultGroupName();
        }
        if (groupName == null) {
            groupName = DEFAULT_GROUP;
        }
        if ((functionList = this.groupMap.get(groupName)) == null) {
            functionList = new ArrayList();
            this.groupMap.put(groupName, functionList);
        }
        functionList.add((Function)SpringUtil.getBean((String)functionDefine.getBeanName()));
    }

    @Override
    public Set<String> getDomains() {
        return this.domainMap.keySet();
    }

    @Override
    public Set<String> getGroups() {
        return this.groupMap.keySet();
    }

    @Override
    public List<Function<?>> getGroupFunctions(String group) {
        return this.groupMap.get(group);
    }
}

