/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.function.impl;

import java.util.List;
import java.util.Map;
import org.tinygroup.function.Function;
import org.tinygroup.function.FunctionManager;
import org.tinygroup.function.exception.FunctionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionManagerImpl
implements FunctionManager {
    private Map<String, List<Function<?>>> functionMap;

    @Override
    public <T> T execute(String functionName, Object ... parameters) {
        List<Function<?>> functionList;
        if (this.functionMap != null && (functionList = this.functionMap.get(functionName)) != null) {
            for (Function<?> function : functionList) {
                boolean match = false;
                try {
                    match = function.isMatch(parameters);
                }
                catch (RuntimeException e) {
                    continue;
                }
                if (!match) continue;
                return (T)function.execute(parameters);
            }
        }
        throw new FunctionException("\u51fd\u6570<" + functionName + ">\u4e0d\u5b58\u5728\u3002");
    }

    @Override
    public void setFunctionMap(Map<String, List<Function<?>>> functionMap) {
        this.functionMap = functionMap;
    }

    @Override
    public Map<String, List<Function<?>>> getFunctionMap() {
        return this.functionMap;
    }
}

