/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.binarytree.impl;

import java.util.Iterator;
import org.tinygroup.binarytree.AVLTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVLTreeImpl<T extends Comparable<T>>
implements AVLTree<T> {
    private Entry<T> root;
    private int size;

    private void rotateLeft(Entry<T> p) {
        Entry r = ((Entry)p).right;
        ((Entry)p).right = r.left;
        if (r.left != null) {
            r.left.parent = (Entry)p;
        }
        r.parent = ((Entry)p).parent;
        if (((Entry)p).parent == null) {
            this.root = r;
        } else if (((Entry)p).parent.left == p) {
            ((Entry)p).parent.left = r;
        } else {
            ((Entry)p).parent.right = r;
        }
        r.left = (Entry)p;
        ((Entry)p).parent = r;
    }

    private void rotateRight(Entry<T> p) {
        Entry l = ((Entry)p).left;
        ((Entry)p).left = l.right;
        if (l.right != null) {
            l.right.parent = (Entry)p;
        }
        l.parent = ((Entry)p).parent;
        if (((Entry)p).parent == null) {
            this.root = l;
        } else if (((Entry)p).parent.right == p) {
            ((Entry)p).parent.right = l;
        } else {
            ((Entry)p).parent.left = l;
        }
        l.right = (Entry)p;
        ((Entry)p).parent = l;
    }

    @Override
    public boolean add(T elem) {
        ++this.size;
        if (this.root == null) {
            this.root = new Entry<T>(elem, null);
            return true;
        }
        Entry tmp = this.root;
        Entry ancestor = null;
        while (true) {
            int comp;
            if ((comp = elem.compareTo((Object)tmp.elem)) == 0) {
                --this.size;
                return false;
            }
            if (tmp.balanceFactor != '=') {
                ancestor = tmp;
            }
            if (comp < 0) {
                if (tmp.left != null) {
                    tmp = tmp.left;
                    continue;
                }
                tmp.left = (Entry)new Entry<T>(elem, tmp);
                this.fixAfterInsertion(ancestor, tmp.left);
                return true;
            }
            if (tmp.right == null) break;
            tmp = tmp.right;
        }
        tmp.right = (Entry)new Entry<T>(elem, tmp);
        this.fixAfterInsertion(ancestor, tmp.right);
        return true;
    }

    protected void fixAfterInsertion(Entry<T> ancestor, Entry<T> inserted) {
        Comparable elem = (Comparable)((Entry)inserted).elem;
        if (ancestor == null) {
            if (elem.compareTo(((Entry)this.root).elem) < 0) {
                ((Entry)this.root).balanceFactor = 'L';
            } else {
                ((Entry)this.root).balanceFactor = 'R';
            }
            this.adjustPath(this.root, inserted);
        } else if (((Entry)ancestor).balanceFactor == 'L' && elem.compareTo(((Entry)ancestor).elem) > 0 || ((Entry)ancestor).balanceFactor == 'R' && elem.compareTo(((Entry)ancestor).elem) < 0) {
            ((Entry)ancestor).balanceFactor = '=';
            this.adjustPath(ancestor, inserted);
        } else if (((Entry)ancestor).balanceFactor == 'R' && elem.compareTo(((Entry)ancestor).right.elem) > 0) {
            ((Entry)ancestor).balanceFactor = '=';
            this.rotateLeft(ancestor);
            this.adjustPath(((Entry)ancestor).parent, inserted);
        } else if (((Entry)ancestor).balanceFactor == 'L' && elem.compareTo(((Entry)ancestor).left.elem) < 0) {
            ((Entry)ancestor).balanceFactor = '=';
            this.rotateRight(ancestor);
            this.adjustPath(((Entry)ancestor).parent, inserted);
        } else if (((Entry)ancestor).balanceFactor == 'L' && elem.compareTo(((Entry)ancestor).left.elem) > 0) {
            this.rotateLeft(((Entry)ancestor).left);
            this.rotateRight(ancestor);
            this.adjustLeftRigth(ancestor, inserted);
        } else if (((Entry)ancestor).balanceFactor == 'R' && elem.compareTo(((Entry)ancestor).right.elem) < 0) {
            this.rotateRight(((Entry)ancestor).right);
            this.rotateLeft(ancestor);
            this.adjustRigthLeft(ancestor, inserted);
        }
    }

    protected void adjustPath(Entry<T> to, Entry<T> inserted) {
        Comparable elem = (Comparable)((Entry)inserted).elem;
        Entry tmp = ((Entry)inserted).parent;
        while (!tmp.equals(to)) {
            if (elem.compareTo(tmp.elem) < 0) {
                tmp.balanceFactor = 'L';
            } else {
                tmp.balanceFactor = 'R';
            }
            tmp = tmp.parent;
        }
    }

    @Deprecated
    protected void adjustLeftRigth(Entry<T> ancestor, Entry<T> inserted) {
        this.adjustLeftRight(ancestor, inserted);
    }

    protected void adjustLeftRight(Entry<T> ancestor, Entry<T> inserted) {
        Comparable elem = (Comparable)((Entry)inserted).elem;
        if (((Entry)ancestor).parent == inserted) {
            ((Entry)ancestor).balanceFactor = '=';
        } else if (elem.compareTo(((Entry)ancestor).parent.elem) < 0) {
            ((Entry)ancestor).balanceFactor = 'R';
            this.adjustPath(((Entry)ancestor).parent.left, inserted);
        } else {
            ((Entry)ancestor).parent.left.balanceFactor = 'L';
            ((Entry)ancestor).balanceFactor = '=';
            this.adjustPath(ancestor, inserted);
        }
    }

    protected void adjustRigthLeft(Entry<T> ancestor, Entry<T> inserted) {
        this.adjustRightLeft(ancestor, inserted);
    }

    protected void adjustRightLeft(Entry<T> ancestor, Entry<T> inserted) {
        Comparable elem = (Comparable)((Entry)inserted).elem;
        if (((Entry)ancestor).parent == inserted) {
            ((Entry)ancestor).balanceFactor = '=';
        } else if (elem.compareTo(((Entry)ancestor).parent.elem) > 0) {
            ((Entry)ancestor).balanceFactor = 'L';
            this.adjustPath(((Entry)ancestor).parent.right, inserted);
        } else {
            ((Entry)ancestor).parent.right.balanceFactor = 'R';
            ((Entry)ancestor).balanceFactor = '=';
            this.adjustPath(ancestor, inserted);
        }
    }

    @Override
    public boolean remove(T elem) {
        Entry<T> e = this.getEntry(elem);
        if (e == null) {
            return false;
        }
        this.deleteEntry(e);
        return true;
    }

    @Override
    public T contains(T o) {
        Entry<T> e = this.getEntry(o);
        if (e != null) {
            return (T)((Comparable)((Entry)e).elem);
        }
        return null;
    }

    private Entry<T> getEntry(T e) {
        Entry tmp = this.root;
        while (tmp != null) {
            int c = e.compareTo((Object)tmp.elem);
            if (c == 0) {
                return tmp;
            }
            if (c < 0) {
                tmp = tmp.left;
                continue;
            }
            tmp = tmp.right;
        }
        return null;
    }

    private void deleteEntry(Entry<T> p) {
        if (((Entry)p).left != null && ((Entry)p).right != null) {
            Entry<T> s = this.successor(p);
            ((Entry)p).elem = ((Entry)s).elem;
        }
        if (((Entry)p).left == null && ((Entry)p).right == null) {
            if (((Entry)p).parent == null) {
                this.root = null;
            } else if (p == ((Entry)p).parent.left) {
                ((Entry)p).parent.left = null;
            } else {
                ((Entry)p).parent.right = null;
            }
        } else {
            Entry rep = ((Entry)p).left != null ? ((Entry)p).left : ((Entry)p).right;
            rep.parent = ((Entry)p).parent;
            if (((Entry)p).parent == null) {
                this.root = rep;
            } else if (p == ((Entry)p).parent.left) {
                ((Entry)p).parent.left = rep;
            } else {
                ((Entry)p).parent.right = rep;
            }
        }
        this.fixAfterDeletion((Comparable)((Entry)p).elem, ((Entry)p).parent);
        ((Entry)p).parent = null;
        ((Entry)p).left = null;
        ((Entry)p).right = null;
        --this.size;
    }

    private Entry<T> successor(Entry<T> e) {
        if (e == null) {
            return null;
        }
        if (e.right != null) {
            Entry p = e.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = e.parent;
        Entry c = e;
        while (p != null && c == p.right) {
            c = p;
            p = p.parent;
        }
        return p;
    }

    protected void fixAfterDeletion(T elem, Entry<T> pAncestor) {
        Entry ancestor = pAncestor;
        boolean heightHasDecreased = true;
        while (ancestor != null && heightHasDecreased) {
            Entry p;
            int comp = elem.compareTo((Object)ancestor.elem);
            if (comp >= 0) {
                if (ancestor.balanceFactor == '=') {
                    ancestor.balanceFactor = 'L';
                    heightHasDecreased = false;
                    continue;
                }
                if (ancestor.balanceFactor == 'R') {
                    ancestor.balanceFactor = '=';
                    ancestor = ancestor.parent;
                    continue;
                }
                if (ancestor.balanceFactor != 'L') continue;
                if (ancestor.left.balanceFactor == '=') {
                    ancestor.left.balanceFactor = 'R';
                    ancestor.balanceFactor = 'L';
                    this.rotateRight(ancestor);
                    heightHasDecreased = false;
                    continue;
                }
                if (ancestor.left.balanceFactor == 'L') {
                    p = ancestor.parent;
                    ancestor.balanceFactor = '=';
                    ancestor.left.balanceFactor = '=';
                    this.rotateRight(ancestor);
                    ancestor = p;
                    continue;
                }
                if (ancestor.left.balanceFactor != 'R') continue;
                p = ancestor.parent;
                if (ancestor.left.right.balanceFactor == 'L') {
                    ancestor.balanceFactor = 'R';
                    ancestor.left.balanceFactor = '=';
                } else if (ancestor.left.right.balanceFactor == 'R') {
                    ancestor.balanceFactor = '=';
                    ancestor.left.balanceFactor = 'L';
                } else {
                    ancestor.balanceFactor = '=';
                    ancestor.left.balanceFactor = '=';
                }
                ancestor.left.right.balanceFactor = '=';
                this.rotateLeft(ancestor.left);
                this.rotateRight(ancestor);
                ancestor = p;
                continue;
            }
            if (comp >= 0) continue;
            if (ancestor.balanceFactor == '=') {
                ancestor.balanceFactor = 'R';
                heightHasDecreased = false;
                continue;
            }
            if (ancestor.balanceFactor == 'L') {
                ancestor.balanceFactor = '=';
                ancestor = ancestor.parent;
                continue;
            }
            if (ancestor.balanceFactor != 'R') continue;
            if (ancestor.right.balanceFactor == '=') {
                ancestor.balanceFactor = 'R';
                ancestor.right.balanceFactor = 'L';
                this.rotateLeft(ancestor);
                heightHasDecreased = false;
                continue;
            }
            if (ancestor.right.balanceFactor == 'R') {
                p = ancestor.parent;
                ancestor.balanceFactor = '=';
                ancestor.right.balanceFactor = '=';
                this.rotateLeft(ancestor);
                ancestor = p;
                continue;
            }
            if (ancestor.right.balanceFactor != 'L') continue;
            p = ancestor.parent;
            if (ancestor.right.left.balanceFactor == 'R') {
                ancestor.balanceFactor = 'L';
                ancestor.right.balanceFactor = '=';
            } else if (ancestor.right.left.balanceFactor == 'L') {
                ancestor.balanceFactor = '=';
                ancestor.right.balanceFactor = 'R';
            } else {
                ancestor.balanceFactor = '=';
                ancestor.right.balanceFactor = '=';
            }
            ancestor.right.left.balanceFactor = '=';
            this.rotateRight(ancestor.right);
            this.rotateLeft(ancestor);
            ancestor = p;
        }
    }

    boolean isAVL() {
        return AVLTreeImpl.checkAVL(this.root);
    }

    static <T extends Comparable<T>> boolean checkAVL(Entry<T> p) {
        if (p == null) {
            return true;
        }
        return Math.abs(AVLTreeImpl.h(((Entry)p).left) - AVLTreeImpl.h(((Entry)p).right)) <= 1 && AVLTreeImpl.checkAVL(((Entry)p).left) && AVLTreeImpl.checkAVL(((Entry)p).right);
    }

    protected static <T extends Comparable<T>> int h(Entry<T> p) {
        if (p == null) {
            return -1;
        }
        return 1 + Math.max(AVLTreeImpl.h(((Entry)p).left), AVLTreeImpl.h(((Entry)p).right));
    }

    @Override
    public int height() {
        return AVLTreeImpl.h(this.root);
    }

    @Override
    public int heightIter() {
        int height = -1;
        Entry temp = this.root;
        while (temp != null) {
            temp = temp.balanceFactor == 'L' ? temp.left : temp.right;
            ++height;
        }
        return height;
    }

    @Override
    public Iterator<T> iterator() {
        return new TreeIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean[] add(T[] elem) {
        boolean[] r = new boolean[elem.length];
        for (int i = 0; i < elem.length; ++i) {
            r[i] = this.add(elem[i]);
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<T> {
        private Entry<T> lastReturned = null;
        private Entry<T> next;

        TreeIterator() {
            this.next = AVLTreeImpl.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            this.lastReturned = this.next;
            this.next = AVLTreeImpl.this.successor(this.next);
            return (Comparable)this.lastReturned.elem;
        }

        @Override
        public void remove() {
            if (this.lastReturned.left != null && this.lastReturned != null) {
                this.next = this.lastReturned;
            }
            AVLTreeImpl.this.deleteEntry(this.lastReturned);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T> {
        private T elem;
        private Entry<T> parent;
        private Entry<T> left;
        private Entry<T> right;
        private char balanceFactor = (char)61;

        public Entry(T elem, Entry<T> parent) {
            this.elem = elem;
            this.parent = parent;
        }
    }
}

