/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.codegen;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import junit.framework.TestCase;
import org.tinygroup.codegen.config.CodeGenMetaData;
import org.tinygroup.codegen.impl.CodeGeneratorDefault;
import org.tinygroup.codegen.util.CodeGenUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;
import org.tinygroup.tinytestutil.AbstractTestUtil;
import org.tinygroup.xstream.XStreamFactory;

public class CodeGenTest
extends TestCase {
    String testJavaPath;
    String testResourcePath;

    protected void setUp() throws Exception {
        super.setUp();
        AbstractTestUtil.init(null, (boolean)true);
    }

    protected void tearDown() throws Exception {
        File javaFile = new File(this.testJavaPath + CodeGenUtil.packageToPath((String)"org.tinygroup.codegen") + "HelloWorld.java");
        CodeGenTest.assertTrue((boolean)javaFile.exists());
        javaFile.deleteOnExit();
        File xmlFile = new File(this.testResourcePath + "test" + File.separator + "helloworld.xml");
        CodeGenTest.assertTrue((boolean)xmlFile.exists());
        xmlFile.deleteOnExit();
    }

    public void testCodeGen() throws Exception {
        XStream xStream = XStreamFactory.getXStream();
        xStream.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        xStream.autodetectAnnotations(true);
        xStream.processAnnotations(CodeGenMetaData.class);
        CodeGenMetaData metaData = (CodeGenMetaData)xStream.fromXML(((Object)((Object)this)).getClass().getResourceAsStream("/test.codegen.xml"));
        Context context = ContextFactory.getContext();
        String projectPath = System.getProperty("user.dir");
        this.testJavaPath = projectPath + File.separator + "src" + File.separator + "test" + File.separator + "java" + File.separator;
        this.testResourcePath = projectPath + File.separator + "src" + File.separator + "test" + File.separator + "resources" + File.separator;
        context.put("JAVA_ROOT", (Object)(projectPath + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator));
        context.put("JAVA_RES_ROOT", (Object)(projectPath + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator));
        context.put("JAVA_TEST_ROOT", (Object)this.testJavaPath);
        context.put("JAVA_TEST_RES_ROOT", (Object)this.testResourcePath);
        context.put("CODE_META_DATA", (Object)metaData);
        context.put("beanPackageName", (Object)"org.tinygroup.codegen");
        context.put("className", (Object)"HelloWorld");
        context.put("ABSOLUTE_PATH", (Object)this.testResourcePath);
        CodeGeneratorDefault generator = new CodeGeneratorDefault();
        generator.generate(context);
    }
}

