/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.codegen.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.codegen.CodeGenerator;
import org.tinygroup.codegen.config.CodeGenMetaData;
import org.tinygroup.codegen.config.MacroDefine;
import org.tinygroup.codegen.config.TemplateDefine;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;
import org.tinygroup.docgen.DocumentGenerater;
import org.tinygroup.docgen.config.GenUtilConfig;
import org.tinygroup.docgen.config.StaticClass;
import org.tinygroup.docgen.function.StaticClassFunction;
import org.tinygroup.docgen.impl.DocumentGeneraterImpl;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.TemplateFunction;
import org.tinygroup.template.impl.TemplateEngineDefault;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGeneratorDefault
implements CodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGeneratorDefault.class);
    private DocumentGenerater<TemplateEngine> generater = new DocumentGeneraterImpl();

    public CodeGeneratorDefault() {
        TemplateEngineDefault templateEngine = new TemplateEngineDefault();
        templateEngine.setEngineId("tiny_code");
        this.generater.setTemplateGenerater((Object)templateEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> generate(Context context) throws IOException {
        CodeGenMetaData metaData = (CodeGenMetaData)context.get("CODE_META_DATA");
        if (metaData == null) {
            throw new RuntimeException("\u4ee3\u7801\u751f\u6210\u5668\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.addUtilClass();
        List<MacroDefine> macroDefines = metaData.getMacroDefines();
        for (MacroDefine macroDefine : macroDefines) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7d\u5b8f\u6587\u4ef6\u8def\u5f84\uff1a{0}", new Object[]{macroDefine.getMacroPath()});
            String macroPath = macroDefine.getMacroPath();
            if (!StringUtils.startsWith((String)macroPath, (String)"/")) {
                macroPath = "/" + macroPath;
            }
            FileObject fileObject = VFS.resolveFile((String)String.valueOf(context.get("ABSOLUTE_PATH")));
            this.generater.addMacroFile(fileObject.getFileObject(macroPath));
            LOGGER.logMessage(LogLevel.INFO, "\u5b8f\u6587\u4ef6\u8def\u5f84\uff1a{0}\uff0c\u52a0\u8f7d\u5b8c\u6bd5", new Object[]{macroDefine.getMacroPath()});
        }
        List<TemplateDefine> templateDefines = metaData.getTemplateDefines();
        ArrayList<String> fileList = new ArrayList<String>();
        for (TemplateDefine templateDefine : templateDefines) {
            Context newContext = this.createNewContext(context, templateDefine);
            String templatePath = templateDefine.getTemplatePath();
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7d\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{0}", new Object[]{templatePath});
            FileObject templateDirObject = VFS.resolveFile((String)String.valueOf(context.get("ABSOLUTE_PATH")));
            LOGGER.logMessage(LogLevel.INFO, "\u6a21\u677f\u6587\u4ef6\u8def\u5f84\uff1a{0}\uff0c\u52a0\u8f7d\u5b8c\u6bd5", new Object[]{templatePath});
            FileObject templateFileObject = templateDirObject.getFileObject(templatePath);
            ((TemplateEngine)this.generater.getTemplateGenerater()).addResourceLoader((ResourceLoader)new FileObjectResourceLoader(templateFileObject.getExtName(), null, null, templateDirObject));
            String generateFile = this.generater.evaluteString(newContext, templateDefine.getFileNameTemplate());
            File file = new File(generateFile);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            try {
                this.generater.generate(templateFileObject, newContext, (Writer)writer);
            }
            finally {
                writer.close();
            }
            fileList.add(file.getPath());
        }
        return fileList;
    }

    private void addUtilClass() {
        XStream stream = new XStream();
        stream.setClassLoader(this.getClass().getClassLoader());
        stream.autodetectAnnotations(true);
        stream.processAnnotations(GenUtilConfig.class);
        GenUtilConfig config = (GenUtilConfig)stream.fromXML(this.getClass().getResourceAsStream("/codegen.util.xml"));
        if (config.getStaticClasses() != null) {
            for (StaticClass staticClass : config.getStaticClasses()) {
                try {
                    StaticClassFunction function = new StaticClassFunction(staticClass.getName(), staticClass.getClassName());
                    ((TemplateEngine)this.generater.getTemplateGenerater()).addTemplateFunction((TemplateFunction)function);
                }
                catch (Exception e) {
                    LOGGER.logMessage(LogLevel.ERROR, "\u9759\u6001\u65b9\u6cd5\u7c7b\uff1a{0}\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", new Object[]{staticClass.getClassName()});
                }
            }
        }
    }

    private Context createNewContext(Context context, TemplateDefine templateDefine) {
        Context newContext = ContextFactory.getContext();
        newContext.setParent(context);
        newContext.put("TEMPLATE_FILE", (Object)templateDefine);
        String templatePath = templateDefine.getTemplatePath();
        String templateFilePath = templatePath.replaceAll("/", "\\" + File.separator);
        String path = StringUtil.substringBeforeLast((String)templateFilePath, (String)File.separator);
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (path.trim().length() > 0 && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        newContext.put("templateFilePath", (Object)path);
        String fileName = StringUtil.substringAfterLast((String)templateFilePath, (String)File.separator);
        newContext.put("templateFileName", (Object)StringUtil.substringBeforeLast((String)fileName, (String)"."));
        return newContext;
    }
}

