/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command.fileresolver;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import org.tinygroup.command.CommandSystem;
import org.tinygroup.command.config.Commands;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class CommandFileProcessor
extends AbstractFileProcessor {
    private static final String COMMAND_EXT_FILENAME = ".commands.xml";

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(COMMAND_EXT_FILENAME);
    }

    public void process() {
        XStream stream = XStreamFactory.getXStream((String)"commands");
        for (FileObject fileObject : this.fileObjects) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7dCommands\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            try {
                InputStream inputStream = fileObject.getInputStream();
                Commands commands = (Commands)stream.fromXML(inputStream);
                inputStream.close();
                CommandSystem.getInstance(commands.getPackageName(), commands, System.out);
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u52a0\u8f7dCommands\u6587\u4ef6[{0}]\u51fa\u73b0\u5f02\u5e38", (Throwable)e, new Object[]{fileObject.getAbsolutePath()});
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dCommands\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

