/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.tinygroup.command.CommandGoalExecutor;
import org.tinygroup.command.config.Command;
import org.tinygroup.command.config.CommandGoal;
import org.tinygroup.command.config.Commands;
import org.tinygroup.command.config.Parameter;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public final class CommandSystem {
    public static final String COMMANDS_XSTREAM = "commands";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSystem.class);
    private static final int ASCII_MAX = 256;
    private static final int MAX_LINE_LENGTH = 80;
    private static Map<String, CommandSystem> commandHelperTable = new HashMap<String, CommandSystem>();
    private static Pattern commandPattern = Pattern.compile("(\\w|[:]|[-])+");
    private static Pattern parameterPattern = Pattern.compile("(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[-])+\\s*=\"[^\"]*\")|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[-])+='[^']*')|(\\b(\\w|[\u4e00-\u9fa5]|[/]|[.]|[-])+=(\\w|[\u4e00-\u9fa5]|[.]|[*]|[%]|[-]|[\\\\]|[/])+)|(\"[^\"]*\"|'[^']*'|(\\w|[\u4e00-\u9fa5]|[.]|[*]|[%]|[-]|[\\\\]|[/])+)");
    private Map<String, Command> commands = new HashMap<String, Command>();
    private Map<String, List<String>> goalInCommand = new HashMap<String, List<String>>();
    private Context context = new ContextImpl();
    private OutputStream out;

    private CommandSystem(Commands commands) {
        for (Command cmd : commands.getCommandList()) {
            this.addCommand(cmd);
        }
    }

    public static CommandSystem getInstance(String name, Commands commands, OutputStream out) {
        CommandSystem commandSystem = commandHelperTable.get(name);
        if (commandSystem == null) {
            commandSystem = new CommandSystem(commands);
            commandHelperTable.put(name, commandSystem);
        } else if (commands != null) {
            for (Command command : commands.getCommandList()) {
                commandSystem.addCommand(command);
            }
        }
        if (out != null) {
            commandSystem.out = out;
        }
        return commandSystem;
    }

    public static CommandSystem getInstance(String name) {
        return commandHelperTable.get(name);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public Context getContext() {
        return this.context;
    }

    private void addCommand(Command set) {
        this.commands.put(set.getName(), set);
        for (CommandGoal commandgoal : set.getCommandGoals()) {
            List<String> cmdSetNames = this.goalInCommand.get(commandgoal.getName());
            if (cmdSetNames == null) {
                cmdSetNames = new ArrayList<String>();
                this.goalInCommand.put(commandgoal.getName(), cmdSetNames);
            }
            cmdSetNames.add(set.getName());
        }
    }

    public void execute(String cmd) {
        List<String> cmds = this.parseCmd(cmd);
        if (cmds.isEmpty()) {
            this.println("\u8bf7\u8f93\u5165\u6709\u6548\u7684\u547d\u4ee4\u53cagoal\uff01 \u83b7\u53d6\u5e2e\u52a9\u4e3a\uff1a h|help");
            return;
        }
        this.execute(cmds);
    }

    private void execute(List<String> cmds) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        String[] str = cmds.get(0).split(":");
        Command command = null;
        CommandGoal goal = null;
        block1 : switch (str.length) {
            case 1: {
                List<String> setsName = this.goalInCommand.get(str[0]);
                if (setsName == null) {
                    this.println("info:invalid-commands");
                    return;
                }
                if (setsName.size() != 1) {
                    this.print("Goal:" + str[0] + "\u5728\u547d\u4ee4[");
                    for (int i = 0; i < setsName.size(); ++i) {
                        if (i > 0) {
                            this.print(",");
                        }
                        this.print(setsName.get(i));
                    }
                    this.println("]\u4e2d\u51fa\u73b0\uff0c\u8bf7\u5728goal\u524d\u6dfb\u52a0\u547d\u4ee4\u3002");
                    return;
                }
                command = this.commands.get(setsName.get(0));
                for (CommandGoal c : command.getCommandGoals()) {
                    if (!c.getName().equals(str[0])) continue;
                    goal = c;
                    break block1;
                }
                break;
            }
            case 2: {
                command = this.commands.get(str[0]);
                if (command == null) break;
                for (CommandGoal c : command.getCommandGoals()) {
                    if (!c.getName().equals(str[1])) continue;
                    goal = c;
                    break block1;
                }
                break;
            }
        }
        if (goal != null && command != null) {
            block9: for (int i = 1; i < cmds.size(); ++i) {
                String strCmd = cmds.get(i);
                int index = strCmd.indexOf(61);
                if (index > 0) {
                    String key = strCmd.substring(0, index);
                    if (goal.getParameters() == null) continue;
                    for (Parameter p : goal.getParameters()) {
                        if (!p.getName().equals(key)) continue;
                        String value = strCmd.substring(index + 1);
                        parameter.put(key, value);
                        continue block9;
                    }
                    continue;
                }
                if (goal.getDefaultParameter() == null) continue;
                if (goal.getDefaultParameter() == null || goal.getDefaultParameter().length() == 0) {
                    this.println("\u65e0\u6548\u7684\u53c2\u6570\uff1a" + strCmd);
                    return;
                }
                parameter.put(goal.getDefaultParameter(), strCmd);
            }
            if (goal.getParameters() != null) {
                for (Parameter p : goal.getParameters()) {
                    if (parameter.get(p.getName()) != null) continue;
                    if (p.getDefaultValue() != null && p.getDefaultValue().length() > 0) {
                        parameter.put(p.getName(), p.getDefaultValue());
                        continue;
                    }
                    if (!p.isNecessary()) continue;
                    this.println("\u53c2\u6570" + p.getName() + "\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    return;
                }
            }
            CommandGoalExecutor commandGoalExecutor = goal.getCommandGoalExecutor();
            for (String property : parameter.keySet()) {
                String v = (String)parameter.get(property);
                try {
                    if (v == null || v.length() <= 0) continue;
                    BeanUtils.setProperty((Object)commandGoalExecutor, (String)property, parameter.get(property));
                }
                catch (Exception e1) {
                    LOGGER.errorMessage("\u5c5e\u6027\u8bbe\u7f6e\u9519\u8bef\uff01\u5c5e\u6027\u540d:{0}\uff0c\u5c5e\u6027\u503c:{1}\u3002", (Throwable)e1, new Object[]{property, v});
                }
            }
            commandGoalExecutor.execute(this, this.context);
        } else {
            this.println("\u65e0\u6548\u7684\u547d\u4ee4:" + cmds.get(0));
        }
    }

    private List<String> parseCmd(String cmd) {
        ArrayList<String> ret = new ArrayList<String>();
        Matcher m = commandPattern.matcher(cmd);
        if (!m.find()) {
            return ret;
        }
        ret.add(m.group());
        int s = m.end();
        m = parameterPattern.matcher(cmd);
        while (m.find(s)) {
            String str = m.group();
            if (str.startsWith("\"") || str.startsWith("'")) {
                ret.add(str.substring(1, str.length() - 1));
            } else {
                ret.add(str);
            }
            s = m.end();
        }
        return ret;
    }

    public void println(String str) {
        this.print(str);
        this.print("\n");
    }

    public void println() {
        this.print("\n");
    }

    public void print(String str) {
        try {
            if (str != null) {
                this.out.write(str.getBytes());
            }
        }
        catch (IOException e) {
            LOGGER.errorMessage("\u5185\u5bb9({0})\u8f93\u5165\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a\u3002", (Throwable)e, new Object[]{str});
        }
    }

    public int indentPrint(String str, int tab) {
        this.printTab(tab);
        int count = tab;
        for (int i = 0; i < str.length(); ++i) {
            String s = str.substring(i, i + 1);
            if (str.charAt(i) >= '\u0000' && str.charAt(i) <= '\u0100') {
                if (count > 80) {
                    this.println("");
                    this.printTab(tab);
                    count = tab;
                }
                this.print(s);
                ++count;
                continue;
            }
            if (count > 80) {
                this.println("");
                this.printTab(tab);
                count = tab;
            }
            this.print(s);
            count += 2;
        }
        return count;
    }

    private void printTab(int tab) {
        for (int i = 0; i < tab; ++i) {
            this.print(String.format(" ", ""));
        }
    }
}

