/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.List;
import org.tinygroup.command.CommandGoalExecutor;
import org.tinygroup.command.config.Parameter;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

@XStreamAlias(value="command-goal")
public class CommandGoal {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandGoal.class);
    @XStreamAsAttribute
    private String name;
    @XStreamAlias(value="default-parameter")
    @XStreamAsAttribute
    private String defaultParameter;
    @XStreamAlias(value="short-description")
    private String shortDescription;
    private String description;
    private List<Parameter> parameters;
    @XStreamAsAttribute
    @XStreamAlias(value="class-name")
    private String className;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDefaultParameter() {
        return this.defaultParameter;
    }

    public void setDefaultParameter(String defaultParameter) {
        this.defaultParameter = defaultParameter;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public CommandGoalExecutor getCommandGoalExecutor() {
        return this.newInstance(this.className);
    }

    private CommandGoalExecutor newInstance(String className2) {
        try {
            return (CommandGoalExecutor)Class.forName(className2).newInstance();
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u52a0\u8f7d\u7c7b<{0}>\u65f6\u51fa\u73b0\u5f02\u5e38!", (Throwable)e, new Object[]{className2});
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }
}

