/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.command.help;

import org.tinygroup.command.CommandGoalExecutor;
import org.tinygroup.command.CommandSystem;
import org.tinygroup.command.config.Command;
import org.tinygroup.command.config.CommandGoal;
import org.tinygroup.command.config.Parameter;
import org.tinygroup.context.Context;

public class HelpHelpGoalExecutor
implements CommandGoalExecutor {
    private String goal;
    private String command;
    private String parameter;
    private boolean showDetail = false;
    private boolean showGoal = false;
    private boolean showParameter = false;

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public boolean isShowParameter() {
        return this.showParameter;
    }

    public void setShowParameter(boolean showParameter) {
        this.showParameter = showParameter;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isShowDetail() {
        return this.showDetail;
    }

    public void setShowDetail(boolean showDetail) {
        this.showDetail = showDetail;
    }

    public boolean isShowGoal() {
        return this.showGoal;
    }

    public void setShowGoal(boolean showGoal) {
        this.showGoal = showGoal;
    }

    @Override
    public void execute(CommandSystem commandSystem, Context context) {
        commandSystem.println("\u7528\u6cd5: [\u547d\u4ee4:]Goal [[\u53c2\u6570\u540d=\u53c2\u6570\u503c]...]");
        commandSystem.print("\u547d\u4ee4");
        commandSystem.indentPrint("Goal", 1);
        commandSystem.indentPrint("\u53c2\u6570", 1);
        commandSystem.println();
        for (String key : commandSystem.getCommands().keySet()) {
            commandSystem.println();
            if (this.command != null && !this.command.equals(key)) continue;
            this.printCommand(commandSystem, key);
        }
    }

    private void printCommand(CommandSystem commandSystem, String key) {
        commandSystem.indentPrint(key, 0);
        Command cmd = commandSystem.getCommands().get(key);
        commandSystem.println();
        if (!this.showDetail) {
            commandSystem.indentPrint(cmd.getShortDescription(), 3);
        } else {
            commandSystem.indentPrint(cmd.getDescription(), 3);
        }
        commandSystem.println();
        this.printCommandGoals(cmd, commandSystem);
    }

    public void printCommandGoals(Command cmd, CommandSystem commandSystem) {
        if (!this.showGoal) {
            return;
        }
        for (CommandGoal commandGoal : cmd.getCommandGoals()) {
            if (this.goal != null && !this.goal.equals(commandGoal.getName())) continue;
            commandSystem.indentPrint(commandGoal.getName(), 6);
            commandSystem.println();
            if (!this.showDetail) {
                commandSystem.indentPrint(commandGoal.getShortDescription(), 9);
            } else {
                commandSystem.indentPrint(commandGoal.getDescription(), 9);
            }
            commandSystem.println();
            this.printCommandGoalParams(commandGoal, commandSystem);
        }
    }

    public void printCommandGoalParams(CommandGoal commandGoal, CommandSystem commandSystem) {
        if (!this.showParameter) {
            return;
        }
        if (commandGoal.getParameters() == null) {
            return;
        }
        for (Parameter para : commandGoal.getParameters()) {
            if (this.parameter != null && !this.parameter.equals(para.getName())) continue;
            commandSystem.indentPrint(para.getName(), 12);
            commandSystem.println();
            if (!this.showDetail) {
                commandSystem.indentPrint(para.getShortDescription(), 15);
            } else {
                commandSystem.indentPrint(para.getDescription(), 15);
            }
            commandSystem.println();
        }
    }
}

