/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exceptionhandler.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.event.Event;
import org.tinygroup.exceptionhandler.ExceptionHandler;
import org.tinygroup.exceptionhandler.ExceptionHandlerManager;

public class ExceptionHandlerManagerImpl
implements ExceptionHandlerManager {
    private Map<String, ExceptionHandler> handlerNameMap = new HashMap<String, ExceptionHandler>();
    private Map<Class<?>, ExceptionHandler> handlerMap = new HashMap();
    private List<Class<?>> exceptionList = new ArrayList();

    public void addHandler(String exception, ExceptionHandler handler) throws ClassNotFoundException {
        if (this.handlerNameMap.containsKey(exception)) {
            return;
        }
        this.handlerNameMap.put(exception, handler);
        Class<?> exceptionClass = Class.forName(exception);
        this.exceptionList.add(exceptionClass);
        this.handlerMap.put(exceptionClass, handler);
    }

    @Override
    public boolean handle(Throwable e, Event event) {
        Class<?> exceptionClass = e.getClass();
        int index = this.exceptionList.indexOf(exceptionClass);
        if (index != -1) {
            this.handlerMap.get(this.exceptionList.get(index)).handle(e, event);
            return true;
        }
        for (int i = 0; i < this.exceptionList.size(); ++i) {
            Class<?> clazz = this.exceptionList.get(i);
            if (!this.implementInterface(exceptionClass, clazz)) continue;
            this.handlerMap.get(clazz).handle(e, event);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleWithAllHandler(Throwable e, Event event) {
        Class<?> exceptionClass = e.getClass();
        boolean flag = false;
        for (int i = 0; i < this.exceptionList.size(); ++i) {
            Class<?> clazz = this.exceptionList.get(i);
            if (!this.implementInterface(exceptionClass, clazz)) continue;
            this.handlerMap.get(clazz).handle(e, event);
            flag = true;
        }
        return flag;
    }

    private boolean implementInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }
}

