/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.convert.objectxml.jaxb.XmlToObject;
import org.tinygroup.convert.objectxml.simple.ObjectToXml;
import org.tinygroup.flowbasiccomponent.FileFormat;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.VFS;

public class DefaultFileFormat
implements FileFormat {
    public static String TINY_FILE_FORMAT_TYPE = "default_tiny_file_format_type";
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultFileFormat.class);

    public static boolean isSimpleType(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE) || clazz.equals(Character.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Boolean.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Float.TYPE)) {
            return true;
        }
        return clazz.equals(Integer.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Boolean.class) || clazz.equals(Short.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(String.class);
    }

    @Override
    public Object formatFile(String filePath, String classPath) {
        try {
            String xml = FileUtil.readFileContent((File)new File(VFS.resolveFile((String)filePath).getAbsolutePath()), (String)this.getEncoding());
            Class<?> clazz = Class.forName(classPath);
            XmlToObject xmlToObject = new XmlToObject(clazz);
            return xmlToObject.convert(xml);
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61\uff1a{0}\u8f6c\u5b58\u5230\u6587\u4ef6\uff1a{1}\u65f6\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a{2}", new Object[]{classPath, filePath, e});
            throw new FlowComponentException("0TE120123004", classPath, filePath, e);
        }
    }

    @Override
    public <T> String formatObject(T t) {
        try {
            if (DefaultFileFormat.isSimpleType(t.getClass())) {
                return String.valueOf(t);
            }
            if (Collection.class.isAssignableFrom(t.getClass())) {
                Iterator iterator = ((Collection)t).iterator();
                String name = "";
                if (iterator.hasNext()) {
                    Class<?> clazz = iterator.next().getClass();
                    name = clazz.getName();
                    name = name.substring(name.lastIndexOf(".") + 1);
                    name = name.replaceFirst(name.substring(0, 1), name.substring(0, 1).toLowerCase());
                }
                ObjectToXml objectToXml = new ObjectToXml(true, name + "-list", name);
                return objectToXml.convert((List)t);
            }
            org.tinygroup.convert.objectxml.jaxb.ObjectToXml objectToXml = new org.tinygroup.convert.objectxml.jaxb.ObjectToXml(t.getClass(), true);
            return objectToXml.convert(t);
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61:{0}\u8f6c\u6362\u4e3aXML\u5b57\u7b26\u4e32\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{t.getClass().getName(), e});
            throw new FlowComponentException("0TE120123023", t.getClass().getName(), e);
        }
    }

    @Override
    public String getType() {
        return TINY_FILE_FORMAT_TYPE;
    }

    @Override
    public String getEncoding() {
        return "GB2312";
    }
}

