/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.flowbasiccomponent.CodeConvert;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.VFS;

public class ResponseCodeConvertUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ResponseCodeConvertUtil.class);
    private static Map<String, CodeConvert> codeConverts = new HashMap<String, CodeConvert>();
    private static Map<String, String> responseCodeMap = new HashMap<String, String>();

    public static String covert(String type, String source) {
        CodeConvert convert = codeConverts.get(type);
        if (convert == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u54cd\u5e94\u7801\u7c7b\u578b\uff1a{0}\u5bf9\u5e94\u7684\u8f6c\u6362\u5668\u672a\u914d\u7f6e", new Object[]{type});
            throw new FlowComponentException("0TE120123002", type);
        }
        return convert.convert(source);
    }

    public static void readFile(String filePath) {
        Properties prop = new Properties();
        InputStream in = VFS.resolveFile((String)filePath).getInputStream();
        try {
            prop.load(in);
        }
        catch (IOException e) {
            LOGGER.logMessage(LogLevel.ERROR, "properties\u6587\u4ef6\uff1a{0}\u8bfb\u53d6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw new FlowComponentException("0TE120123020", filePath, e);
        }
        Set<Map.Entry<Object, Object>> set = prop.entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        String key = null;
        String value = null;
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            key = String.valueOf(entry.getKey());
            value = String.valueOf(entry.getValue());
            key = key == null ? key : key.trim();
            value = value == null ? value : value.trim();
            responseCodeMap.put(key, value);
        }
    }

    public static String codeConvert(String key) {
        if (responseCodeMap.containsKey(key)) {
            return responseCodeMap.get(key);
        }
        return responseCodeMap.get("default_code");
    }

    static {
        Collection collection = BeanContainerFactory.getBeanContainer((ClassLoader)ResponseCodeConvertUtil.class.getClassLoader()).getBeans(CodeConvert.class);
        for (CodeConvert convert : collection) {
            codeConverts.put(convert.getType(), convert);
        }
    }
}

