/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.convert.objectxml.jaxb.ObjectToXml;
import org.tinygroup.convert.objectxml.jaxb.XmlToObject;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;
import org.tinygroup.xmlparser.XmlNodeType;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class XMLOperatorUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(XMLOperatorUtil.class);

    public static XmlNode getXmlNode(String xml) {
        return (XmlNode)new XmlStringParser().parse(xml).getRoot();
    }

    public static XmlNode getXmlNodeFromFile(String filePath, String encoding) {
        try {
            if (StringUtil.isBlank((String)encoding)) {
                encoding = "UTF-8";
            }
            FileObject fileObject = VFS.resolveFile((String)filePath);
            String applicationConfig = StreamUtil.readText((InputStream)fileObject.getInputStream(), (String)encoding, (boolean)true);
            XmlNode xmlNode = (XmlNode)new XmlStringParser().parse(applicationConfig).getRoot();
            return xmlNode;
        }
        catch (IOException e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5c06\u6587\u4ef6\uff1a{0}\u5e8f\u5217\u5316\u4e3aXmlNode\u5bf9\u8c61\u65f6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw new FlowComponentException("0TE120123003", filePath, e);
        }
    }

    private static void writeToXml(String filePath, XmlNode xmlNode, String encoding) {
        try {
            if (StringUtil.isBlank((String)encoding)) {
                encoding = "UTF-8";
            }
            FileObject fileObject = VFS.resolveFile((String)filePath);
            XmlNode xn = new XmlNode(XmlNodeType.XML_DECLARATION);
            xn.setAttribute("version", "1.0");
            xn.setAttribute("encoding", encoding);
            StringBuffer sb = new StringBuffer();
            sb.append(xn);
            sb.append(xmlNode);
            StreamUtil.writeText((CharSequence)sb.toString(), (OutputStream)fileObject.getOutputStream(), (String)encoding, (boolean)true);
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5c06\u4fee\u6539\u540e\u7684xml\u5185\u5bb9\u5bfc\u51fa\u5230xml\u6811\uff1a{0}\u65f6\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw new FlowComponentException("0TE120123004", xmlNode.getClass().getName(), filePath, e);
        }
    }

    public static XmlNode getSubNode(String nodePath, XmlNode xmlNode) {
        PathFilter pathFilter = new PathFilter((Node)xmlNode);
        XmlNode node = (XmlNode)pathFilter.findNode(nodePath);
        return node;
    }

    public static String getNodeListStr(List<XmlNode> nodes) {
        String xml = "";
        if (nodes != null && nodes.size() > 0) {
            for (XmlNode node : nodes) {
                xml = xml + node.toString();
            }
        }
        return xml;
    }

    public static void appendValue(XmlNode xml, String nodePath, String nodeValue) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u8ffd\u52a0\u5185\u5bb9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            throw new FlowComponentException("0TE120123009", xml, nodePath);
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u5728\u8282\u70b9\uff1a{0}\u4e0b\u8ffd\u52a0\u5185\u5bb9\uff1a{1}", new Object[]{nodePath, nodeValue});
        node.addContent(nodeValue);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u8ffd\u52a0\u5185\u5bb9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
    }

    public static void insertNode(XmlNode xml, String nodePath, String xmlNode) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u8ffd\u52a0\u5185\u5bb9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            throw new FlowComponentException("0TE120123009", xml, nodePath);
        }
        XmlNode xn = (XmlNode)new XmlStringParser().parse(xmlNode).getRoot();
        LOGGER.logMessage(LogLevel.DEBUG, "\u5728\u8282\u70b9\uff1a{0}\u4e0b\u8ffd\u52a0\u5185\u5bb9\uff1a{1}", new Object[]{nodePath, xn.toString()});
        node.addNode((Node)xn);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u8ffd\u52a0\u5185\u5bb9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
    }

    public static void updateValue(XmlNode xml, String nodePath, String nodeValue) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u4fee\u6539\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            throw new FlowComponentException("0TE120123009", xml, nodePath);
        }
        List nodes = node.removeSubNotes();
        LOGGER.logMessage(LogLevel.DEBUG, "\u4fee\u6539\u8282\u70b9\uff1a{0}\u7684\u539f\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, XMLOperatorUtil.getNodeListStr(nodes)});
        node.addContent(nodeValue);
        LOGGER.logMessage(LogLevel.DEBUG, "\u4fee\u6539\u8282\u70b9\uff1a{0}\u7684\u65b0\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, nodeValue});
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u4fee\u6539\u8282\u70b9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
    }

    public static void repalceNode(XmlNode xml, String nodePath, String xmlNode) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u8986\u76d6\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            throw new FlowComponentException("0TE120123009", xml, nodePath);
        }
        List nodes = node.removeSubNotes();
        LOGGER.logMessage(LogLevel.DEBUG, "\u8986\u76d6\u8282\u70b9\uff1a{0}\u7684\u539f\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, XMLOperatorUtil.getNodeListStr(nodes)});
        XmlNode xn = (XmlNode)new XmlStringParser().parse(xmlNode).getRoot();
        LOGGER.logMessage(LogLevel.DEBUG, "\u8986\u76d6\u8282\u70b9\uff1a{0}\u7684\u65b0\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, xn.toString()});
        node.addNode((Node)xn);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u8986\u76d6\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
    }

    public static String deleteNode(XmlNode xml, String nodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u5220\u9664\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        LOGGER.logMessage(LogLevel.DEBUG, "\u5728\u6307\u5b9a\u8282\u70b9\uff1a{0}\u5220\u9664\u7684\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, node.toString()});
        XmlNode parnetNode = (XmlNode)node.getParent();
        parnetNode.removeNode((Node)node);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
        return node.toString();
    }

    public static String deleteSubNode(XmlNode xml, String nodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u5220\u9664\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        List deleteNodes = node.removeSubNotes();
        String removeXml = XMLOperatorUtil.getNodeListStr(deleteNodes);
        LOGGER.logMessage(LogLevel.DEBUG, "\u5728\u6307\u5b9a\u8282\u70b9\uff1a{0}\u5220\u9664\u7684\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, removeXml});
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
        return removeXml;
    }

    public static String deleteByNodeName(XmlNode xml, String nodePath, String nodeName) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u5220\u9664\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        List deleteNodes = node.removeNode(nodeName);
        String removeXml = XMLOperatorUtil.getNodeListStr(deleteNodes);
        LOGGER.logMessage(LogLevel.DEBUG, "\u5728\u6307\u5b9a\u8282\u70b9\uff1a{0}\u5220\u9664\u7684\u5185\u5bb9\u4e3a\uff1a{1}", new Object[]{nodePath, removeXml});
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u5220\u9664\u8282\u70b9\u64cd\u4f5c\u6210\u529f", new Object[]{xml});
        return removeXml;
    }

    public static XmlNode queryNode(XmlNode xml, String nodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.INFO, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u67e5\u8be2\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        if (node.getSubNodes().size() == 1 && StringUtil.isBlank((String)((XmlNode)node.getSubNodes().get(0)).getNodeName())) {
            return (XmlNode)node.getSubNodes().get(0);
        }
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c\u6210\u529f\u3002\u67e5\u8be2\u6307\u5b9a\u8282\u70b9\uff1a{1}\u7684\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a{2}", new Object[]{xml, nodePath, node.toString()});
        return node;
    }

    public static List<XmlNode> querySubNode(XmlNode xml, String nodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.INFO, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u67e5\u8be2\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        List queryNodes = node.getSubNodes();
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c\u6210\u529f\u3002\u67e5\u8be2\u6307\u5b9a\u8282\u70b9\uff1a{1}\u7684\u5b50\u8282\u70b9\u5171\u6709\uff1a{2}\u4e2a", new Object[]{xml, nodePath, queryNodes.size()});
        return queryNodes;
    }

    public static List<XmlNode> queryByNodeName(XmlNode xml, String nodePath, String nodeName) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c", new Object[]{xml});
        XmlNode node = XMLOperatorUtil.getSubNode(nodePath, xml);
        if (node == null) {
            LOGGER.logMessage(LogLevel.INFO, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u67e5\u8be2\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
            return null;
        }
        List queryNodes = node.getSubNodes(nodeName);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u67e5\u8282\u70b9\u64cd\u4f5c\u6210\u529f\u3002\u67e5\u8be2\u6307\u5b9a\u8282\u70b9\uff1a{1}\u7684\u5b50\u8282\u70b9\u540d\u4e3a\uff1a{2}\u7684\u8282\u70b9\u5171\u6709\uff1a{3}\u4e2a", new Object[]{xml, nodePath, nodeName, queryNodes.size()});
        return queryNodes;
    }

    public static void moveNode(XmlNode xml, String fromNodePath, String toNodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u8282\u70b9move\u64cd\u4f5c\uff0c\u5c06\u8282\u70b9\uff1a{1}\u79fb\u52a8\u5230\u8282\u70b9\uff1a{2}", new Object[]{xml, fromNodePath, toNodePath});
        XmlNode formNode = XMLOperatorUtil.getSubNode(fromNodePath, xml);
        if (formNode == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u51c6\u5907\u79fb\u52a8\u8282\u70b9\uff1a{1}", new Object[]{xml, fromNodePath});
            throw new FlowComponentException("0TE120123009", xml, fromNodePath);
        }
        XmlNode toNode = XMLOperatorUtil.getSubNode(toNodePath, xml);
        if (toNode == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u76ee\u7684\u5730\u8282\u70b9\uff1a{1}", new Object[]{xml, toNodePath});
            throw new FlowComponentException("0TE120123009", xml, toNodePath);
        }
        toNode.getSubNodes().add(formNode);
        ((XmlNode)formNode.getParent()).removeNode((Node)formNode);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u8282\u70b9move\u64cd\u4f5c\uff0c\u6210\u529f\u5c06\u8282\u70b9\uff1a{1}\u79fb\u52a8\u5230\u8282\u70b9\uff1a{2}", new Object[]{xml, fromNodePath, toNodePath});
    }

    public static void copyNode(XmlNode xml, String fromNodePath, String toNodePath) {
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u8282\u70b9copy\u64cd\u4f5c\uff0c\u5c06\u8282\u70b9\uff1a{1}\u590d\u5236\u5230\u8282\u70b9\uff1a{2}", new Object[]{xml, fromNodePath, toNodePath});
        XmlNode formNode = XMLOperatorUtil.getSubNode(fromNodePath, xml);
        if (formNode == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u51c6\u5907\u590d\u5236\u8282\u70b9\uff1a{1}", new Object[]{xml, fromNodePath});
            throw new FlowComponentException("0TE120123009", xml, fromNodePath);
        }
        XmlNode toNode = XMLOperatorUtil.getSubNode(toNodePath, xml);
        if (toNode == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u76ee\u7684\u5730\u8282\u70b9\uff1a{1}", new Object[]{xml, toNodePath});
            throw new FlowComponentException("0TE120123009", xml, toNodePath);
        }
        toNode.getSubNodes().add(formNode);
        LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u7ed3\u675f\uff1a{0}\uff0c\u6267\u884c\u8282\u70b9copy\u64cd\u4f5c\uff0c\u6210\u529f\u5c06\u8282\u70b9\uff1a{1}\u590d\u5236\u5230\u8282\u70b9\uff1a{2}", new Object[]{xml, fromNodePath, toNodePath});
    }

    public static void export(XmlNode xml, String exportfilePath, String nodePath, String encoding) {
        if (!StringUtil.isBlank((String)nodePath)) {
            LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u5c06\u8282\u70b9\uff1a{1}\u5bfc\u51fa\u5230\u6587\u4ef6\uff1a{2}", new Object[]{xml, nodePath, exportfilePath});
        } else {
            LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u5c06xml\u5bfc\u51fa\u5230\u6587\u4ef6\uff1a{2}", new Object[]{xml, exportfilePath});
        }
        if (!StringUtil.isBlank((String)nodePath)) {
            XmlNode subNode = XMLOperatorUtil.getSubNode(nodePath, xml);
            if (subNode == null) {
                LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u9700\u8981\u5bfc\u51fa\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
                throw new FlowComponentException("0TE120123009", xml, nodePath);
            }
            XMLOperatorUtil.writeToXml(exportfilePath, subNode, encoding);
            LOGGER.logMessage(LogLevel.DEBUG, "xml\u6811\u64cd\u4f5c\u6210\u529f\uff1a{0}\uff0c\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u5c06\u8282\u70b9\uff1a{1}\u6210\u529f\u5bfc\u51fa\u5230\u6587\u4ef6\uff1a{2}", new Object[]{xml, nodePath, exportfilePath});
            return;
        }
        XMLOperatorUtil.writeToXml(exportfilePath, xml, encoding);
        LOGGER.logMessage(LogLevel.DEBUG, "xml\u6811\u64cd\u4f5c\u6210\u529f\uff1a{0}\uff0c\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\uff0c\u5c06xml\u6811\u6210\u529f\u5bfc\u51fa\u5230\u6587\u4ef6\uff1a{2}", new Object[]{xml, exportfilePath});
    }

    public static void importFile(XmlNode xml, String importfilePath, String nodePath, String encoding) {
        if (!StringUtil.isBlank((String)nodePath)) {
            LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u5c06\u6587\u4ef6:{1}\u5bfc\u5165\u5230\u8282\u70b9\uff1a{2}", new Object[]{xml, importfilePath, nodePath});
        } else {
            LOGGER.logMessage(LogLevel.DEBUG, "XML\u6811\u64cd\u4f5c\u5f00\u59cb\uff1a{0}\uff0c\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u5c06\u6587\u4ef6:{1}\u5bfc\u5165xml\u6811\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u540e\u65b9", new Object[]{xml, importfilePath});
        }
        XmlNode importNode = XMLOperatorUtil.getXmlNodeFromFile(importfilePath, encoding);
        if (!StringUtil.isBlank((String)nodePath)) {
            XmlNode subNode = XMLOperatorUtil.getSubNode(nodePath, xml);
            if (subNode == null) {
                LOGGER.logMessage(LogLevel.ERROR, "\u5728xml\u6811\uff1a{0}\u4e2d\u672a\u627e\u5230\u51c6\u5907\u5bfc\u5165\u7684\u8282\u70b9\uff1a{1}", new Object[]{xml, nodePath});
                throw new FlowComponentException("0TE120123009", xml, nodePath);
            }
            subNode.getSubNodes().add(importNode);
            LOGGER.logMessage(LogLevel.DEBUG, "xml\u6811\u64cd\u4f5c\u6210\u529f\uff1a{0}\uff0c\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u5c06\u6587\u4ef6:{1}\u5bfc\u5165\u5230\u8282\u70b9\uff1a{2}\u6210\u529f", new Object[]{xml, importfilePath, nodePath});
        }
        xml.getSubNodes().add(importNode);
        LOGGER.logMessage(LogLevel.DEBUG, "xml\u6811\u64cd\u4f5c\u6210\u529f\uff1a{0}\uff0c\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u5c06\u6587\u4ef6:{1}\u5bfc\u5165xml\u6811\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u540e\u65b9\u6210\u529f", new Object[]{xml, importfilePath});
    }

    public static String getValue(XmlNode xmlNode, String nodePath) {
        XmlNode subNode = XMLOperatorUtil.getSubNode(nodePath, xmlNode);
        return subNode.getContent();
    }

    public static Object formatXml(String xml, String classPath) {
        try {
            Class<?> clazz = Class.forName(classPath);
            XmlToObject xmlToObject = new XmlToObject(clazz);
            return xmlToObject.convert(xml);
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61\uff1a{0}\u8f6c\u5b58\u5230\u6587\u4ef6\uff1a{1}\u65f6\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a{2}", new Object[]{xml, classPath, e});
            throw new FlowComponentException("0TE120123004", xml, classPath, e);
        }
    }

    public static <T> String formatObject(T t) {
        try {
            ObjectToXml objectToXml = new ObjectToXml(t.getClass(), true);
            return objectToXml.convert(t);
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61:{0}\u8f6c\u6362\u4e3aXML\u5b57\u7b26\u4e32\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{t, e});
            throw new FlowComponentException("0TE120123023", t, e);
        }
    }
}

