/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.htmlparser.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.htmlparser.HtmlDocument;
import org.tinygroup.htmlparser.node.HtmlNode;

public class HtmlDocumentImpl
implements HtmlDocument {
    private HtmlNode root = null;
    private HtmlNode htmlDeclaration = null;
    private List<HtmlNode> commentList = null;
    private List<HtmlNode> doctypeList = null;
    private List<HtmlNode> processingInstructionList = null;

    public HtmlNode getRoot() {
        return this.root;
    }

    public void setRoot(HtmlNode root) {
        this.root = root;
    }

    @Override
    public HtmlNode getHtmlDeclaration() {
        return this.htmlDeclaration;
    }

    @Override
    public void setHtmlDeclaration(HtmlNode htmlDeclaration) {
        this.htmlDeclaration = htmlDeclaration;
    }

    @Override
    public List<HtmlNode> getCommentList() {
        return this.commentList;
    }

    @Override
    public List<HtmlNode> getDoctypeList() {
        return this.doctypeList;
    }

    @Override
    public List<HtmlNode> getProcessingInstructionList() {
        return this.processingInstructionList;
    }

    @Override
    public void addDoctype(HtmlNode node) {
        if (this.doctypeList == null) {
            this.doctypeList = new ArrayList<HtmlNode>();
        }
        this.doctypeList.add(node);
    }

    @Override
    public void addProcessingInstruction(HtmlNode node) {
        if (this.processingInstructionList == null) {
            this.processingInstructionList = new ArrayList<HtmlNode>();
        }
        this.processingInstructionList.add(node);
    }

    @Override
    public void addComment(HtmlNode node) {
        if (this.commentList == null) {
            this.commentList = new ArrayList<HtmlNode>();
        }
        this.commentList.add(node);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.htmlDeclaration != null) {
            sb.append(this.htmlDeclaration.toStringBuffer());
        }
        if (this.commentList != null) {
            for (HtmlNode n : this.commentList) {
                sb.append(n.toStringBuffer());
            }
        }
        if (this.doctypeList != null) {
            for (HtmlNode n : this.doctypeList) {
                sb.append(n.toStringBuffer());
            }
        }
        if (this.processingInstructionList != null) {
            for (HtmlNode n : this.processingInstructionList) {
                sb.append(n.toStringBuffer());
            }
        }
        sb.append(this.root.toStringBuffer());
        return sb.toString();
    }

    public void write(OutputStream out) throws IOException {
        if (this.htmlDeclaration != null) {
            this.htmlDeclaration.write(out);
        }
        if (this.commentList != null) {
            for (HtmlNode n : this.commentList) {
                n.write(out);
            }
        }
        if (this.doctypeList != null) {
            for (HtmlNode n : this.doctypeList) {
                n.write(out);
            }
        }
        if (this.processingInstructionList != null) {
            for (HtmlNode n : this.processingInstructionList) {
                n.write(out);
            }
        }
        this.root.write(out);
    }
}

