/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.htmlparser.node;

import java.util.HashSet;
import org.tinygroup.htmlparser.HtmlNodeType;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeType;
import org.tinygroup.parser.node.NodeImpl;

public class HtmlNode
extends NodeImpl<HtmlNode, HtmlNodeType> {
    public static HashSet<String> singleNodeNames = new HashSet();

    public HtmlNode(HtmlNodeType nodeType) {
        super((NodeType)nodeType);
    }

    public HtmlNode(String nodeName) {
        super(nodeName, (NodeType)HtmlNodeType.ELEMENT);
    }

    public HtmlNode(HtmlNodeType nodeType, String nodeName) {
        super((NodeType)nodeType, nodeName);
    }

    public HtmlNode(String nodeName, HtmlNodeType nodeType) {
        super((NodeType)nodeType, nodeName);
    }

    public HtmlNode getRoot() {
        HtmlNode root = (HtmlNode)super.getRoot();
        if (root.getNodeName() == null && root.getSubNodes().size() == 1) {
            return (HtmlNode)((Object)root.getSubNodes().get(0));
        }
        return root;
    }

    public boolean isSingleNode() {
        if (this.getNodeName() != null) {
            return singleNodeNames.contains(this.getCaseSensitiveName(this.getNodeName()));
        }
        return false;
    }

    public HtmlNode addContent(String content) {
        HtmlNode node = new HtmlNode(HtmlNodeType.TEXT);
        node.setContent(content);
        this.addNode((Node)node);
        return this;
    }

    protected String encode(String string) {
        String str = string;
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll(" ", "&nbsp;");
        str = str.replaceAll("'", "&apos;");
        return str;
    }

    protected String decode(String string) {
        String str = string;
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&nbsp;", " ");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&apos;", "'");
        return str;
    }

    public String getPureText() {
        StringBuffer sb = new StringBuffer();
        this.getPureText(this, sb);
        return sb.toString().trim();
    }

    void getPureText(HtmlNode node, StringBuffer sb) {
        if (node.getNodeType() == HtmlNodeType.CDATA || node.getNodeType() == HtmlNodeType.TEXT) {
            String content = node.getContent();
            if (content != null) {
                sb.append(content).append(" ");
            }
        } else if (((HtmlNodeType)node.getNodeType()).isHasHeader() && node.getSubNodes() != null) {
            for (HtmlNode n : node.getSubNodes()) {
                this.getPureText(n, sb);
            }
        }
    }

    public boolean isCaseSensitive() {
        return false;
    }

    static {
        singleNodeNames.add("br");
        singleNodeNames.add("hr");
        singleNodeNames.add("img");
        singleNodeNames.add("input");
        singleNodeNames.add("param");
        singleNodeNames.add("meta");
        singleNodeNames.add("link");
    }
}

